import { JsonRpcError } from 'jsonrpc-lite';
import { AppObjectRegistry } from '../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../lib/accessors/mod.ts';
export default async function apiHandler(call, params) {
  const [, path, httpMethod] = call.split(':');
  const endpoint = AppObjectRegistry.get(`api:${path}`);
  const logger = AppObjectRegistry.get('logger');
  if (!endpoint) {
    return new JsonRpcError(`Endpoint ${path} not found`, -32000);
  }
  const method = endpoint[httpMethod];
  if (typeof method !== 'function') {
    return new JsonRpcError(`${path}'s ${httpMethod} not exists`, -32000);
  }
  const [request, endpointInfo] = params;
  logger?.debug(`${path}'s ${call} is being executed...`, request);
  try {
    // deno-lint-ignore ban-types
    const result = await method.apply(endpoint, [
      request,
      endpointInfo,
      AppAccessorsInstance.getReader(),
      AppAccessorsInstance.getModifier(),
      AppAccessorsInstance.getHttp(),
      AppAccessorsInstance.getPersistence()
    ]);
    logger?.debug(`${path}'s ${call} was successfully executed.`);
    return result;
  } catch (e) {
    logger?.debug(`${path}'s ${call} was unsuccessful.`);
    return new JsonRpcError(e.message || 'Internal server error', -32000);
  }
}
//# sourceMappingURL=data:application/json;base64,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