import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default async function handleOnDisable() {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.onDisable !== 'function') {
    throw new Error('App must contain an onDisable function', {
      cause: 'invalid_app'
    });
  }
  await app.onDisable(AppAccessorsInstance.getConfigurationModify());
  return true;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvaGFuZGxlcnMvYXBwL2hhbmRsZU9uRGlzYWJsZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdHlwZSB7IEFwcCB9IGZyb20gJ0Byb2NrZXQuY2hhdC9hcHBzLWVuZ2luZS9kZWZpbml0aW9uL0FwcC50cyc7XG5cbmltcG9ydCB7IEFwcE9iamVjdFJlZ2lzdHJ5IH0gZnJvbSAnLi4vLi4vQXBwT2JqZWN0UmVnaXN0cnkudHMnO1xuaW1wb3J0IHsgQXBwQWNjZXNzb3JzSW5zdGFuY2UgfSBmcm9tICcuLi8uLi9saWIvYWNjZXNzb3JzL21vZC50cyc7XG5cbmV4cG9ydCBkZWZhdWx0IGFzeW5jIGZ1bmN0aW9uIGhhbmRsZU9uRGlzYWJsZSgpOiBQcm9taXNlPGJvb2xlYW4+IHtcblx0Y29uc3QgYXBwID0gQXBwT2JqZWN0UmVnaXN0cnkuZ2V0PEFwcD4oJ2FwcCcpO1xuXG5cdGlmICh0eXBlb2YgYXBwPy5vbkRpc2FibGUgIT09ICdmdW5jdGlvbicpIHtcblx0XHR0aHJvdyBuZXcgRXJyb3IoJ0FwcCBtdXN0IGNvbnRhaW4gYW4gb25EaXNhYmxlIGZ1bmN0aW9uJywge1xuXHRcdFx0Y2F1c2U6ICdpbnZhbGlkX2FwcCcsXG5cdFx0fSk7XG5cdH1cblxuXHRhd2FpdCBhcHAub25EaXNhYmxlKEFwcEFjY2Vzc29yc0luc3RhbmNlLmdldENvbmZpZ3VyYXRpb25Nb2RpZnkoKSk7XG5cblx0cmV0dXJuIHRydWU7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBRUEsU0FBUyxpQkFBaUIsUUFBUSw2QkFBNkI7QUFDL0QsU0FBUyxvQkFBb0IsUUFBUSw2QkFBNkI7QUFFbEUsZUFBZSxlQUFlO0VBQzdCLE1BQU0sTUFBTSxrQkFBa0IsR0FBRyxDQUFNO0VBRXZDLElBQUksT0FBTyxLQUFLLGNBQWMsWUFBWTtJQUN6QyxNQUFNLElBQUksTUFBTSwwQ0FBMEM7TUFDekQsT0FBTztJQUNSO0VBQ0Q7RUFFQSxNQUFNLElBQUksU0FBUyxDQUFDLHFCQUFxQixzQkFBc0I7RUFFL0QsT0FBTztBQUNSIn0=