import { AppObjectRegistry } from '../../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../../lib/accessors/mod.ts';
export default function handleOnEnable() {
  const app = AppObjectRegistry.get('app');
  if (typeof app?.onEnable !== 'function') {
    throw new Error('App must contain an onEnable function', {
      cause: 'invalid_app'
    });
  }
  return app.onEnable(AppAccessorsInstance.getEnvironmentRead(), AppAccessorsInstance.getConfigurationModify());
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvaGFuZGxlcnMvYXBwL2hhbmRsZU9uRW5hYmxlLnRzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB0eXBlIHsgQXBwIH0gZnJvbSAnQHJvY2tldC5jaGF0L2FwcHMtZW5naW5lL2RlZmluaXRpb24vQXBwLnRzJztcblxuaW1wb3J0IHsgQXBwT2JqZWN0UmVnaXN0cnkgfSBmcm9tICcuLi8uLi9BcHBPYmplY3RSZWdpc3RyeS50cyc7XG5pbXBvcnQgeyBBcHBBY2Nlc3NvcnNJbnN0YW5jZSB9IGZyb20gJy4uLy4uL2xpYi9hY2Nlc3NvcnMvbW9kLnRzJztcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gaGFuZGxlT25FbmFibGUoKTogUHJvbWlzZTxib29sZWFuPiB7XG5cdGNvbnN0IGFwcCA9IEFwcE9iamVjdFJlZ2lzdHJ5LmdldDxBcHA+KCdhcHAnKTtcblxuXHRpZiAodHlwZW9mIGFwcD8ub25FbmFibGUgIT09ICdmdW5jdGlvbicpIHtcblx0XHR0aHJvdyBuZXcgRXJyb3IoJ0FwcCBtdXN0IGNvbnRhaW4gYW4gb25FbmFibGUgZnVuY3Rpb24nLCB7XG5cdFx0XHRjYXVzZTogJ2ludmFsaWRfYXBwJyxcblx0XHR9KTtcblx0fVxuXG5cdHJldHVybiBhcHAub25FbmFibGUoQXBwQWNjZXNzb3JzSW5zdGFuY2UuZ2V0RW52aXJvbm1lbnRSZWFkKCksIEFwcEFjY2Vzc29yc0luc3RhbmNlLmdldENvbmZpZ3VyYXRpb25Nb2RpZnkoKSk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBRUEsU0FBUyxpQkFBaUIsUUFBUSw2QkFBNkI7QUFDL0QsU0FBUyxvQkFBb0IsUUFBUSw2QkFBNkI7QUFFbEUsZUFBZSxTQUFTO0VBQ3ZCLE1BQU0sTUFBTSxrQkFBa0IsR0FBRyxDQUFNO0VBRXZDLElBQUksT0FBTyxLQUFLLGFBQWEsWUFBWTtJQUN4QyxNQUFNLElBQUksTUFBTSx5Q0FBeUM7TUFDeEQsT0FBTztJQUNSO0VBQ0Q7RUFFQSxPQUFPLElBQUksUUFBUSxDQUFDLHFCQUFxQixrQkFBa0IsSUFBSSxxQkFBcUIsc0JBQXNCO0FBQzNHIn0=