import { JsonRpcError } from 'jsonrpc-lite';
import { AppObjectRegistry } from '../AppObjectRegistry.ts';
import { AppAccessorsInstance } from '../lib/accessors/mod.ts';
export default async function videoConferenceHandler(call, params) {
  const [, providerName, methodName] = call.split(':');
  const provider = AppObjectRegistry.get(`videoConfProvider:${providerName}`);
  const logger = AppObjectRegistry.get('logger');
  if (!provider) {
    return new JsonRpcError(`Provider ${providerName} not found`, -32000);
  }
  const method = provider[methodName];
  if (typeof method !== 'function') {
    return JsonRpcError.methodNotFound({
      message: `Method ${methodName} not found on provider ${providerName}`
    });
  }
  const [videoconf, user, options] = params;
  logger?.debug(`Executing ${methodName} on video conference provider...`);
  const args = [
    ...videoconf ? [
      videoconf
    ] : [],
    ...user ? [
      user
    ] : [],
    ...options ? [
      options
    ] : []
  ];
  try {
    // deno-lint-ignore ban-types
    const result = await method.apply(provider, [
      ...args,
      AppAccessorsInstance.getReader(),
      AppAccessorsInstance.getModifier(),
      AppAccessorsInstance.getHttp(),
      AppAccessorsInstance.getPersistence()
    ]);
    logger?.debug(`Video Conference Provider's ${methodName} was successfully executed.`);
    return result;
  } catch (e) {
    logger?.debug(`Video Conference Provider's ${methodName} was unsuccessful.`);
    return new JsonRpcError(e.message, -32000);
  }
}
//# sourceMappingURL=data:application/json;base64,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