import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
export class VideoConferenceBuilder {
  kind = RocketChatAssociationModel.VIDEO_CONFERENCE;
  call;
  constructor(data){
    this.call = data || {};
  }
  setData(data) {
    this.call = {
      rid: data.rid,
      createdBy: data.createdBy,
      providerName: data.providerName,
      title: data.title,
      discussionRid: data.discussionRid
    };
    return this;
  }
  setRoomId(rid) {
    this.call.rid = rid;
    return this;
  }
  getRoomId() {
    return this.call.rid;
  }
  setCreatedBy(userId) {
    this.call.createdBy = userId;
    return this;
  }
  getCreatedBy() {
    return this.call.createdBy;
  }
  setProviderName(userId) {
    this.call.providerName = userId;
    return this;
  }
  getProviderName() {
    return this.call.providerName;
  }
  setProviderData(data) {
    this.call.providerData = data;
    return this;
  }
  getProviderData() {
    return this.call.providerData;
  }
  setTitle(userId) {
    this.call.title = userId;
    return this;
  }
  getTitle() {
    return this.call.title;
  }
  setDiscussionRid(rid) {
    this.call.discussionRid = rid;
    return this;
  }
  getDiscussionRid() {
    return this.call.discussionRid;
  }
  getVideoConference() {
    return this.call;
  }
}
//# sourceMappingURL=data:application/json;base64,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