export class HttpExtend {
  headers;
  params;
  requests;
  responses;
  constructor(){
    this.headers = new Map();
    this.params = new Map();
    this.requests = [];
    this.responses = [];
  }
  provideDefaultHeader(key, value) {
    this.headers.set(key, value);
  }
  provideDefaultHeaders(headers) {
    Object.keys(headers).forEach((key)=>this.headers.set(key, headers[key]));
  }
  provideDefaultParam(key, value) {
    this.params.set(key, value);
  }
  provideDefaultParams(params) {
    Object.keys(params).forEach((key)=>this.params.set(key, params[key]));
  }
  providePreRequestHandler(handler) {
    this.requests.push(handler);
  }
  providePreResponseHandler(handler) {
    this.responses.push(handler);
  }
  getDefaultHeaders() {
    return new Map(this.headers);
  }
  getDefaultParams() {
    return new Map(this.params);
  }
  getPreRequestHandlers() {
    return Array.from(this.requests);
  }
  getPreResponseHandlers() {
    return Array.from(this.responses);
  }
}
//# sourceMappingURL=data:application/json;base64,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