import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
export class MessageExtender {
  msg;
  kind;
  constructor(msg){
    this.msg = msg;
    this.kind = RocketChatAssociationModel.MESSAGE;
    if (!Array.isArray(msg.attachments)) {
      this.msg.attachments = [];
    }
  }
  addCustomField(key, value) {
    if (!this.msg.customFields) {
      this.msg.customFields = {};
    }
    if (this.msg.customFields[key]) {
      throw new Error(`The message already contains a custom field by the key: ${key}`);
    }
    if (key.includes('.')) {
      throw new Error(`The given key contains a period, which is not allowed. Key: ${key}`);
    }
    this.msg.customFields[key] = value;
    return this;
  }
  addAttachment(attachment) {
    this.ensureAttachment();
    this.msg.attachments.push(attachment);
    return this;
  }
  addAttachments(attachments) {
    this.ensureAttachment();
    this.msg.attachments = this.msg.attachments.concat(attachments);
    return this;
  }
  getMessage() {
    return structuredClone(this.msg);
  }
  ensureAttachment() {
    if (!Array.isArray(this.msg.attachments)) {
      this.msg.attachments = [];
    }
  }
}
//# sourceMappingURL=data:application/json;base64,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