import { require } from '../../../lib/require.ts';
const { RocketChatAssociationModel } = require('@rocket.chat/apps-engine/definition/metadata/RocketChatAssociations.js');
export class RoomExtender {
  room;
  kind;
  members;
  constructor(room){
    this.room = room;
    this.kind = RocketChatAssociationModel.ROOM;
    this.members = [];
  }
  addCustomField(key, value) {
    if (!this.room.customFields) {
      this.room.customFields = {};
    }
    if (this.room.customFields[key]) {
      throw new Error(`The room already contains a custom field by the key: ${key}`);
    }
    if (key.includes('.')) {
      throw new Error(`The given key contains a period, which is not allowed. Key: ${key}`);
    }
    this.room.customFields[key] = value;
    return this;
  }
  addMember(user) {
    if (this.members.find((u)=>u.username === user.username)) {
      throw new Error('The user is already in the room.');
    }
    this.members.push(user);
    return this;
  }
  getMembersBeingAdded() {
    return this.members;
  }
  getUsernamesOfMembersBeingAdded() {
    return this.members.map((u)=>u.username);
  }
  getRoom() {
    return structuredClone(this.room);
  }
}
//# sourceMappingURL=data:application/json;base64,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