import { generate } from 'astring';
// @deno-types="../../acorn.d.ts"
import { parse } from 'acorn';
// @deno-types="../../acorn-walk.d.ts"
import { fullAncestor } from 'acorn-walk';
import * as operations from './operations.ts';
function fixAst(ast) {
  const pendingOperations = [
    operations.fixLivechatIsOnlineCalls,
    operations.checkReassignmentOfModifiedIdentifiers,
    operations.fixRoomUsernamesCalls
  ];
  // Have we touched the tree?
  let isModified = false;
  while(pendingOperations.length){
    const ops = pendingOperations.splice(0);
    const state = {
      isModified: false,
      functionIdentifiers: new Set()
    };
    fullAncestor(ast, (node, state, ancestors, type)=>{
      ops.forEach((operation)=>operation(node, state, ancestors, type));
    }, undefined, state);
    if (state.isModified) {
      isModified = true;
    }
    if (state.functionIdentifiers.size) {
      pendingOperations.push(operations.buildFixModifiedFunctionsOperation(state.functionIdentifiers), operations.checkReassignmentOfModifiedIdentifiers);
    }
  }
  return isModified;
}
export function fixBrokenSynchronousAPICalls(appSource) {
  const astRootNode = parse(appSource, {
    // Latest ecma version supported by this version of acorn.
    ecmaVersion: "latest",
    // Allow everything, we don't want to complain if code is badly written
    // Also, since the code itself has been transpiled, the chance of getting
    // shenanigans is lower
    allowReserved: true,
    allowReturnOutsideFunction: true,
    allowImportExportEverywhere: true,
    allowAwaitOutsideFunction: true,
    allowSuperOutsideMethod: true
  });
  if (fixAst(astRootNode)) {
    return generate(astRootNode);
  }
  return appSource;
}
//# sourceMappingURL=data:application/json;base64,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