import { createRequire } from 'node:module';
const _require = createRequire(import.meta.url);
export const require = (mod)=>{
  // When we try to import something from the apps-engine, we resolve the path using import maps from Deno
  // However, the import maps are configured to look at the source folder for typescript files, but during
  // runtime those files are not available
  if (mod.startsWith('@rocket.chat/apps-engine')) {
    mod = import.meta.resolve(mod).replace('file://', '').replace('src/', '');
  }
  return _require(mod);
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9kZW5vLXJ1bnRpbWUvbGliL3JlcXVpcmUudHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgY3JlYXRlUmVxdWlyZSB9IGZyb20gJ25vZGU6bW9kdWxlJztcblxuY29uc3QgX3JlcXVpcmUgPSBjcmVhdGVSZXF1aXJlKGltcG9ydC5tZXRhLnVybCk7XG5cbmV4cG9ydCBjb25zdCByZXF1aXJlID0gKG1vZDogc3RyaW5nKSA9PiB7XG5cdC8vIFdoZW4gd2UgdHJ5IHRvIGltcG9ydCBzb21ldGhpbmcgZnJvbSB0aGUgYXBwcy1lbmdpbmUsIHdlIHJlc29sdmUgdGhlIHBhdGggdXNpbmcgaW1wb3J0IG1hcHMgZnJvbSBEZW5vXG5cdC8vIEhvd2V2ZXIsIHRoZSBpbXBvcnQgbWFwcyBhcmUgY29uZmlndXJlZCB0byBsb29rIGF0IHRoZSBzb3VyY2UgZm9sZGVyIGZvciB0eXBlc2NyaXB0IGZpbGVzLCBidXQgZHVyaW5nXG5cdC8vIHJ1bnRpbWUgdGhvc2UgZmlsZXMgYXJlIG5vdCBhdmFpbGFibGVcblx0aWYgKG1vZC5zdGFydHNXaXRoKCdAcm9ja2V0LmNoYXQvYXBwcy1lbmdpbmUnKSkge1xuXHRcdG1vZCA9IGltcG9ydC5tZXRhLnJlc29sdmUobW9kKS5yZXBsYWNlKCdmaWxlOi8vJywgJycpLnJlcGxhY2UoJ3NyYy8nLCAnJyk7XG5cdH1cblxuXHRyZXR1cm4gX3JlcXVpcmUobW9kKTtcbn07XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsU0FBUyxhQUFhLFFBQVEsY0FBYztBQUU1QyxNQUFNLFdBQVcsY0FBYyxZQUFZLEdBQUc7QUFFOUMsT0FBTyxNQUFNLFVBQVUsQ0FBQztFQUN2Qix3R0FBd0c7RUFDeEcsd0dBQXdHO0VBQ3hHLHdDQUF3QztFQUN4QyxJQUFJLElBQUksVUFBVSxDQUFDLDZCQUE2QjtJQUMvQyxNQUFNLFlBQVksT0FBTyxDQUFDLEtBQUssT0FBTyxDQUFDLFdBQVcsSUFBSSxPQUFPLENBQUMsUUFBUTtFQUN2RTtFQUVBLE9BQU8sU0FBUztBQUNqQixFQUFFIn0=