export var AppStatus;
(function(AppStatus) {
  /** The status is known, aka not been constructed the proper way. */ AppStatus["UNKNOWN"] = "unknown";
  /** The App has been constructed but that's it. */ AppStatus["CONSTRUCTED"] = "constructed";
  /** The App's `initialize()` was called and returned true. */ AppStatus["INITIALIZED"] = "initialized";
  /** The App's `onEnable()` was called, returned true, and this was done automatically (system start up). */ AppStatus["AUTO_ENABLED"] = "auto_enabled";
  /** The App's `onEnable()` was called, returned true, and this was done by the user such as installing a new one. */ AppStatus["MANUALLY_ENABLED"] = "manually_enabled";
  /**
	 * The App was disabled due to an error while attempting to compile it.
	 * An attempt to enable it again will fail, as it needs to be updated.
	 */ AppStatus["COMPILER_ERROR_DISABLED"] = "compiler_error_disabled";
  /**
	 * The App was disable due to its license being invalid
	 */ AppStatus["INVALID_LICENSE_DISABLED"] = "invalid_license_disabled";
  /**
	 * The app was disabled due to an invalid installation or validation in its signature.
	 */ AppStatus["INVALID_INSTALLATION_DISABLED"] = "invalid_installation_disabled";
  /** The App was disabled due to an unrecoverable error being thrown. */ AppStatus["ERROR_DISABLED"] = "error_disabled";
  /** The App was manually disabled by a user. */ AppStatus["MANUALLY_DISABLED"] = "manually_disabled";
  AppStatus["INVALID_SETTINGS_DISABLED"] = "invalid_settings_disabled";
  /** The App was disabled due to other circumstances. */ AppStatus["DISABLED"] = "disabled";
})(AppStatus || (AppStatus = {}));
export class AppStatusUtilsDef {
  isEnabled(status) {
    switch(status){
      case AppStatus.AUTO_ENABLED:
      case AppStatus.MANUALLY_ENABLED:
        return true;
      default:
        return false;
    }
  }
  isDisabled(status) {
    switch(status){
      case AppStatus.COMPILER_ERROR_DISABLED:
      case AppStatus.ERROR_DISABLED:
      case AppStatus.MANUALLY_DISABLED:
      case AppStatus.INVALID_SETTINGS_DISABLED:
      case AppStatus.INVALID_LICENSE_DISABLED:
      case AppStatus.INVALID_INSTALLATION_DISABLED:
      case AppStatus.DISABLED:
        return true;
      default:
        return false;
    }
  }
  isError(status) {
    return [
      AppStatus.ERROR_DISABLED,
      AppStatus.COMPILER_ERROR_DISABLED
    ].includes(status);
  }
}
export const AppStatusUtils = new AppStatusUtilsDef();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9zcmMvZGVmaW5pdGlvbi9BcHBTdGF0dXMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGVudW0gQXBwU3RhdHVzIHtcblx0LyoqIFRoZSBzdGF0dXMgaXMga25vd24sIGFrYSBub3QgYmVlbiBjb25zdHJ1Y3RlZCB0aGUgcHJvcGVyIHdheS4gKi9cblx0VU5LTk9XTiA9ICd1bmtub3duJyxcblx0LyoqIFRoZSBBcHAgaGFzIGJlZW4gY29uc3RydWN0ZWQgYnV0IHRoYXQncyBpdC4gKi9cblx0Q09OU1RSVUNURUQgPSAnY29uc3RydWN0ZWQnLFxuXHQvKiogVGhlIEFwcCdzIGBpbml0aWFsaXplKClgIHdhcyBjYWxsZWQgYW5kIHJldHVybmVkIHRydWUuICovXG5cdElOSVRJQUxJWkVEID0gJ2luaXRpYWxpemVkJyxcblx0LyoqIFRoZSBBcHAncyBgb25FbmFibGUoKWAgd2FzIGNhbGxlZCwgcmV0dXJuZWQgdHJ1ZSwgYW5kIHRoaXMgd2FzIGRvbmUgYXV0b21hdGljYWxseSAoc3lzdGVtIHN0YXJ0IHVwKS4gKi9cblx0QVVUT19FTkFCTEVEID0gJ2F1dG9fZW5hYmxlZCcsXG5cdC8qKiBUaGUgQXBwJ3MgYG9uRW5hYmxlKClgIHdhcyBjYWxsZWQsIHJldHVybmVkIHRydWUsIGFuZCB0aGlzIHdhcyBkb25lIGJ5IHRoZSB1c2VyIHN1Y2ggYXMgaW5zdGFsbGluZyBhIG5ldyBvbmUuICovXG5cdE1BTlVBTExZX0VOQUJMRUQgPSAnbWFudWFsbHlfZW5hYmxlZCcsXG5cdC8qKlxuXHQgKiBUaGUgQXBwIHdhcyBkaXNhYmxlZCBkdWUgdG8gYW4gZXJyb3Igd2hpbGUgYXR0ZW1wdGluZyB0byBjb21waWxlIGl0LlxuXHQgKiBBbiBhdHRlbXB0IHRvIGVuYWJsZSBpdCBhZ2FpbiB3aWxsIGZhaWwsIGFzIGl0IG5lZWRzIHRvIGJlIHVwZGF0ZWQuXG5cdCAqL1xuXHRDT01QSUxFUl9FUlJPUl9ESVNBQkxFRCA9ICdjb21waWxlcl9lcnJvcl9kaXNhYmxlZCcsXG5cdC8qKlxuXHQgKiBUaGUgQXBwIHdhcyBkaXNhYmxlIGR1ZSB0byBpdHMgbGljZW5zZSBiZWluZyBpbnZhbGlkXG5cdCAqL1xuXHRJTlZBTElEX0xJQ0VOU0VfRElTQUJMRUQgPSAnaW52YWxpZF9saWNlbnNlX2Rpc2FibGVkJyxcblx0LyoqXG5cdCAqIFRoZSBhcHAgd2FzIGRpc2FibGVkIGR1ZSB0byBhbiBpbnZhbGlkIGluc3RhbGxhdGlvbiBvciB2YWxpZGF0aW9uIGluIGl0cyBzaWduYXR1cmUuXG5cdCAqL1xuXHRJTlZBTElEX0lOU1RBTExBVElPTl9ESVNBQkxFRCA9ICdpbnZhbGlkX2luc3RhbGxhdGlvbl9kaXNhYmxlZCcsXG5cdC8qKiBUaGUgQXBwIHdhcyBkaXNhYmxlZCBkdWUgdG8gYW4gdW5yZWNvdmVyYWJsZSBlcnJvciBiZWluZyB0aHJvd24uICovXG5cdEVSUk9SX0RJU0FCTEVEID0gJ2Vycm9yX2Rpc2FibGVkJyxcblx0LyoqIFRoZSBBcHAgd2FzIG1hbnVhbGx5IGRpc2FibGVkIGJ5IGEgdXNlci4gKi9cblx0TUFOVUFMTFlfRElTQUJMRUQgPSAnbWFudWFsbHlfZGlzYWJsZWQnLFxuXHRJTlZBTElEX1NFVFRJTkdTX0RJU0FCTEVEID0gJ2ludmFsaWRfc2V0dGluZ3NfZGlzYWJsZWQnLFxuXHQvKiogVGhlIEFwcCB3YXMgZGlzYWJsZWQgZHVlIHRvIG90aGVyIGNpcmN1bXN0YW5jZXMuICovXG5cdERJU0FCTEVEID0gJ2Rpc2FibGVkJyxcbn1cblxuZXhwb3J0IGNsYXNzIEFwcFN0YXR1c1V0aWxzRGVmIHtcblx0cHVibGljIGlzRW5hYmxlZChzdGF0dXM6IEFwcFN0YXR1cyk6IGJvb2xlYW4ge1xuXHRcdHN3aXRjaCAoc3RhdHVzKSB7XG5cdFx0XHRjYXNlIEFwcFN0YXR1cy5BVVRPX0VOQUJMRUQ6XG5cdFx0XHRjYXNlIEFwcFN0YXR1cy5NQU5VQUxMWV9FTkFCTEVEOlxuXHRcdFx0XHRyZXR1cm4gdHJ1ZTtcblx0XHRcdGRlZmF1bHQ6XG5cdFx0XHRcdHJldHVybiBmYWxzZTtcblx0XHR9XG5cdH1cblxuXHRwdWJsaWMgaXNEaXNhYmxlZChzdGF0dXM6IEFwcFN0YXR1cyk6IGJvb2xlYW4ge1xuXHRcdHN3aXRjaCAoc3RhdHVzKSB7XG5cdFx0XHRjYXNlIEFwcFN0YXR1cy5DT01QSUxFUl9FUlJPUl9ESVNBQkxFRDpcblx0XHRcdGNhc2UgQXBwU3RhdHVzLkVSUk9SX0RJU0FCTEVEOlxuXHRcdFx0Y2FzZSBBcHBTdGF0dXMuTUFOVUFMTFlfRElTQUJMRUQ6XG5cdFx0XHRjYXNlIEFwcFN0YXR1cy5JTlZBTElEX1NFVFRJTkdTX0RJU0FCTEVEOlxuXHRcdFx0Y2FzZSBBcHBTdGF0dXMuSU5WQUxJRF9MSUNFTlNFX0RJU0FCTEVEOlxuXHRcdFx0Y2FzZSBBcHBTdGF0dXMuSU5WQUxJRF9JTlNUQUxMQVRJT05fRElTQUJMRUQ6XG5cdFx0XHRjYXNlIEFwcFN0YXR1cy5ESVNBQkxFRDpcblx0XHRcdFx0cmV0dXJuIHRydWU7XG5cdFx0XHRkZWZhdWx0OlxuXHRcdFx0XHRyZXR1cm4gZmFsc2U7XG5cdFx0fVxuXHR9XG5cblx0cHVibGljIGlzRXJyb3Ioc3RhdHVzOiBBcHBTdGF0dXMpOiBib29sZWFuIHtcblx0XHRyZXR1cm4gW0FwcFN0YXR1cy5FUlJPUl9ESVNBQkxFRCwgQXBwU3RhdHVzLkNPTVBJTEVSX0VSUk9SX0RJU0FCTEVEXS5pbmNsdWRlcyhzdGF0dXMpO1xuXHR9XG59XG5cbmV4cG9ydCBjb25zdCBBcHBTdGF0dXNVdGlscyA9IG5ldyBBcHBTdGF0dXNVdGlsc0RlZigpO1xuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7VUFBWTtFQUNYLGtFQUFrRTtFQUVsRSxnREFBZ0Q7RUFFaEQsMkRBQTJEO0VBRTNELHlHQUF5RztFQUV6RyxrSEFBa0g7RUFFbEg7OztFQUdDO0VBRUQ7O0VBRUM7RUFFRDs7RUFFQztFQUVELHFFQUFxRTtFQUVyRSw2Q0FBNkM7O0VBRzdDLHFEQUFxRDtHQTdCMUMsY0FBQTtBQWlDWixPQUFPLE1BQU07RUFDTCxVQUFVLE1BQWlCLEVBQVc7SUFDNUMsT0FBUTtNQUNQLEtBQUssVUFBVSxZQUFZO01BQzNCLEtBQUssVUFBVSxnQkFBZ0I7UUFDOUIsT0FBTztNQUNSO1FBQ0MsT0FBTztJQUNUO0VBQ0Q7RUFFTyxXQUFXLE1BQWlCLEVBQVc7SUFDN0MsT0FBUTtNQUNQLEtBQUssVUFBVSx1QkFBdUI7TUFDdEMsS0FBSyxVQUFVLGNBQWM7TUFDN0IsS0FBSyxVQUFVLGlCQUFpQjtNQUNoQyxLQUFLLFVBQVUseUJBQXlCO01BQ3hDLEtBQUssVUFBVSx3QkFBd0I7TUFDdkMsS0FBSyxVQUFVLDZCQUE2QjtNQUM1QyxLQUFLLFVBQVUsUUFBUTtRQUN0QixPQUFPO01BQ1I7UUFDQyxPQUFPO0lBQ1Q7RUFDRDtFQUVPLFFBQVEsTUFBaUIsRUFBVztJQUMxQyxPQUFPO01BQUMsVUFBVSxjQUFjO01BQUUsVUFBVSx1QkFBdUI7S0FBQyxDQUFDLFFBQVEsQ0FBQztFQUMvRTtBQUNEO0FBRUEsT0FBTyxNQUFNLGlCQUFpQixJQUFJLG9CQUFvQiJ9