export var ApiVisibility;
(function(ApiVisibility) {
  /**
	 * A public Api has a fixed format for a url. Using it enables an
	 * easy to remember structure, however, it also means the url is
	 * intelligently guessed. As a result, we recommend having some
	 * sort of security setup if you must have a public api.Whether
	 * you use the provided security, ApiSecurity, or implement your own.
	 * Url format:
	 * `https://{your-server-address}/api/apps/public/{your-app-id}/{path}`
	 */ ApiVisibility[ApiVisibility["PUBLIC"] = 0] = "PUBLIC";
  /**
	 * Private Api's contain a random value in the url format,
	 * making them harder go guess by default. The random value
	 * will be generated whenever the App is installed on a server.
	 * This means that the URL will not be the same on any server,
	 * but will remain the same throughout the lifecycle of an App
	 * including updates. As a result, if a user uninstalls the App
	 * and reinstalls the App, then the random value will change.
	 * Url format:
	 * `https://{your-server-address}/api/apps/private/{your-app-id}/{random-hash}/{path}`
	 */ ApiVisibility[ApiVisibility["PRIVATE"] = 1] = "PRIVATE";
})(ApiVisibility || (ApiVisibility = {}));
export var ApiSecurity;
(function(ApiSecurity) {
  /**
	 * No security check will be executed agains the calls made to this URL
	 */ ApiSecurity[ApiSecurity["UNSECURE"] = 0] = "UNSECURE";
})(ApiSecurity || (ApiSecurity = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9zcmMvZGVmaW5pdGlvbi9hcGkvSUFwaS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgdHlwZSB7IElBcGlFbmRwb2ludCB9IGZyb20gJy4vSUFwaUVuZHBvaW50JztcblxuLyoqXG4gKiBSZXByZXNlbnRzIGFuIGFwaSB0aGF0IGlzIGJlaW5nIHByb3ZpZGVkLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIElBcGkge1xuXHQvKipcblx0ICogUHJvdmlkZXMgdGhlIHZpc2liaWxpdHkgbWV0aG9kIG9mIHRoZSBVUkwsIHNlZSB0aGUgQXBpVmlzaWJpbGl0eSBkZXNjcmlwdGlvbnMgZm9yIG1vcmUgaW5mb3JtYXRpb25cblx0ICovXG5cdHZpc2liaWxpdHk6IEFwaVZpc2liaWxpdHk7XG5cdC8qKlxuXHQgKiBQcm92aWRlcyB0aGUgdmlzaWJpbGl0eSBtZXRob2Qgb2YgdGhlIFVSTCwgc2VlIHRoZSBBcGlTZWN1cml0eSBkZXNjcmlwdGlvbnMgZm9yIG1vcmUgaW5mb3JtYXRpb25cblx0ICovXG5cdHNlY3VyaXR5OiBBcGlTZWN1cml0eTtcblx0LyoqXG5cdCAqIFByb3ZpZGUgZW5wb2ludHMgZm9yIHRoaXMgYXBpIHJlZ2lzdHJ5XG5cdCAqL1xuXHRlbmRwb2ludHM6IEFycmF5PElBcGlFbmRwb2ludD47XG59XG5cbmV4cG9ydCBlbnVtIEFwaVZpc2liaWxpdHkge1xuXHQvKipcblx0ICogQSBwdWJsaWMgQXBpIGhhcyBhIGZpeGVkIGZvcm1hdCBmb3IgYSB1cmwuIFVzaW5nIGl0IGVuYWJsZXMgYW5cblx0ICogZWFzeSB0byByZW1lbWJlciBzdHJ1Y3R1cmUsIGhvd2V2ZXIsIGl0IGFsc28gbWVhbnMgdGhlIHVybCBpc1xuXHQgKiBpbnRlbGxpZ2VudGx5IGd1ZXNzZWQuIEFzIGEgcmVzdWx0LCB3ZSByZWNvbW1lbmQgaGF2aW5nIHNvbWVcblx0ICogc29ydCBvZiBzZWN1cml0eSBzZXR1cCBpZiB5b3UgbXVzdCBoYXZlIGEgcHVibGljIGFwaS5XaGV0aGVyXG5cdCAqIHlvdSB1c2UgdGhlIHByb3ZpZGVkIHNlY3VyaXR5LCBBcGlTZWN1cml0eSwgb3IgaW1wbGVtZW50IHlvdXIgb3duLlxuXHQgKiBVcmwgZm9ybWF0OlxuXHQgKiBgaHR0cHM6Ly97eW91ci1zZXJ2ZXItYWRkcmVzc30vYXBpL2FwcHMvcHVibGljL3t5b3VyLWFwcC1pZH0ve3BhdGh9YFxuXHQgKi9cblx0UFVCTElDLFxuXHQvKipcblx0ICogUHJpdmF0ZSBBcGkncyBjb250YWluIGEgcmFuZG9tIHZhbHVlIGluIHRoZSB1cmwgZm9ybWF0LFxuXHQgKiBtYWtpbmcgdGhlbSBoYXJkZXIgZ28gZ3Vlc3MgYnkgZGVmYXVsdC4gVGhlIHJhbmRvbSB2YWx1ZVxuXHQgKiB3aWxsIGJlIGdlbmVyYXRlZCB3aGVuZXZlciB0aGUgQXBwIGlzIGluc3RhbGxlZCBvbiBhIHNlcnZlci5cblx0ICogVGhpcyBtZWFucyB0aGF0IHRoZSBVUkwgd2lsbCBub3QgYmUgdGhlIHNhbWUgb24gYW55IHNlcnZlcixcblx0ICogYnV0IHdpbGwgcmVtYWluIHRoZSBzYW1lIHRocm91Z2hvdXQgdGhlIGxpZmVjeWNsZSBvZiBhbiBBcHBcblx0ICogaW5jbHVkaW5nIHVwZGF0ZXMuIEFzIGEgcmVzdWx0LCBpZiBhIHVzZXIgdW5pbnN0YWxscyB0aGUgQXBwXG5cdCAqIGFuZCByZWluc3RhbGxzIHRoZSBBcHAsIHRoZW4gdGhlIHJhbmRvbSB2YWx1ZSB3aWxsIGNoYW5nZS5cblx0ICogVXJsIGZvcm1hdDpcblx0ICogYGh0dHBzOi8ve3lvdXItc2VydmVyLWFkZHJlc3N9L2FwaS9hcHBzL3ByaXZhdGUve3lvdXItYXBwLWlkfS97cmFuZG9tLWhhc2h9L3twYXRofWBcblx0ICovXG5cdFBSSVZBVEUsXG59XG5cbmV4cG9ydCBlbnVtIEFwaVNlY3VyaXR5IHtcblx0LyoqXG5cdCAqIE5vIHNlY3VyaXR5IGNoZWNrIHdpbGwgYmUgZXhlY3V0ZWQgYWdhaW5zIHRoZSBjYWxscyBtYWRlIHRvIHRoaXMgVVJMXG5cdCAqL1xuXHRVTlNFQ1VSRSxcblx0LyoqXG5cdCAqIE9ubHkgY2FsbHMgY29udGFpbmluZyBhIHZhbGlkIHRva2VuIHdpbGwgYmUgYWJsZSB0byBleGVjdXRlIHRoZSBhcGlcblx0ICogTXV0aXBsZSB0b2tlbnMgY2FuIGJlIGdlbmVyYXRlZCB0byBhY2Nlc3MgdGhlIGFwaSwgYnkgZGVmYXVsdCBvbmVcblx0ICogd2lsbCBiZSBnZW5lcmF0ZWQgYXV0b21hdGljYWxseS5cblx0ICogQHBhcmFtIGBYLUF1dGgtVG9rZW5gXG5cdCAqL1xuXHQvLyBDSEVDS1NVTV9TRUNSRVQsXG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtVQW9CWTtFQUNYOzs7Ozs7OztFQVFDO0VBRUQ7Ozs7Ozs7Ozs7RUFVQztHQXJCVSxrQkFBQTs7VUF5QkE7RUFDWDs7RUFFQztHQUhVLGdCQUFBIn0=