/**
 * The internal exception from the framework
 *
 * It's used to signal to the outside world that
 * a _known_ exception has happened during the execution
 * of the apps.
 *
 * It's the base exception for other known classes
 * such as UserNotAllowedException, which is used
 * to inform the host that an app identified
 * that a user cannot perform some action, e.g.
 * join a room
 */ export class AppsEngineException extends Error {
  name = 'AppsEngineException';
  static JSONRPC_ERROR_CODE = -32070;
  message;
  constructor(message){
    super();
    this.message = message;
  }
  getErrorInfo() {
    return {
      name: this.name,
      message: this.message
    };
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9zcmMvZGVmaW5pdGlvbi9leGNlcHRpb25zL0FwcHNFbmdpbmVFeGNlcHRpb24udHMiXSwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBUaGUgaW50ZXJuYWwgZXhjZXB0aW9uIGZyb20gdGhlIGZyYW1ld29ya1xuICpcbiAqIEl0J3MgdXNlZCB0byBzaWduYWwgdG8gdGhlIG91dHNpZGUgd29ybGQgdGhhdFxuICogYSBfa25vd25fIGV4Y2VwdGlvbiBoYXMgaGFwcGVuZWQgZHVyaW5nIHRoZSBleGVjdXRpb25cbiAqIG9mIHRoZSBhcHBzLlxuICpcbiAqIEl0J3MgdGhlIGJhc2UgZXhjZXB0aW9uIGZvciBvdGhlciBrbm93biBjbGFzc2VzXG4gKiBzdWNoIGFzIFVzZXJOb3RBbGxvd2VkRXhjZXB0aW9uLCB3aGljaCBpcyB1c2VkXG4gKiB0byBpbmZvcm0gdGhlIGhvc3QgdGhhdCBhbiBhcHAgaWRlbnRpZmllZFxuICogdGhhdCBhIHVzZXIgY2Fubm90IHBlcmZvcm0gc29tZSBhY3Rpb24sIGUuZy5cbiAqIGpvaW4gYSByb29tXG4gKi9cbmV4cG9ydCBjbGFzcyBBcHBzRW5naW5lRXhjZXB0aW9uIGV4dGVuZHMgRXJyb3Ige1xuXHRwdWJsaWMgbmFtZSA9ICdBcHBzRW5naW5lRXhjZXB0aW9uJztcblxuXHRwdWJsaWMgc3RhdGljIEpTT05SUENfRVJST1JfQ09ERSA9IC0zMjA3MDtcblxuXHRwdWJsaWMgbWVzc2FnZTogc3RyaW5nO1xuXG5cdGNvbnN0cnVjdG9yKG1lc3NhZ2U/OiBzdHJpbmcpIHtcblx0XHRzdXBlcigpO1xuXHRcdHRoaXMubWVzc2FnZSA9IG1lc3NhZ2U7XG5cdH1cblxuXHRwdWJsaWMgZ2V0RXJyb3JJbmZvKCkge1xuXHRcdHJldHVybiB7XG5cdFx0XHRuYW1lOiB0aGlzLm5hbWUsXG5cdFx0XHRtZXNzYWdlOiB0aGlzLm1lc3NhZ2UsXG5cdFx0fTtcblx0fVxufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7Ozs7Ozs7Q0FZQyxHQUNELE9BQU8sTUFBTSw0QkFBNEI7RUFDakMsT0FBTyxzQkFBc0I7RUFFcEMsT0FBYyxxQkFBcUIsQ0FBQyxNQUFNO0VBRW5DLFFBQWdCO0VBRXZCLFlBQVksT0FBZ0IsQ0FBRTtJQUM3QixLQUFLO0lBQ0wsSUFBSSxDQUFDLE9BQU8sR0FBRztFQUNoQjtFQUVPLGVBQWU7SUFDckIsT0FBTztNQUNOLE1BQU0sSUFBSSxDQUFDLElBQUk7TUFDZixTQUFTLElBQUksQ0FBQyxPQUFPO0lBQ3RCO0VBQ0Q7QUFDRCJ9