/**
 * Represents  the slash command's context when a user
 * executes a slash command.
 */ export class SlashCommandContext {
  sender;
  room;
  params;
  threadId;
  triggerId;
  constructor(sender, room, params, threadId, triggerId){
    this.sender = sender;
    this.room = room;
    this.params = params;
    this.threadId = threadId;
    this.triggerId = triggerId;
  }
  /** The user who sent the command. */ getSender() {
    return this.sender;
  }
  /** The room where the command was sent in. */ getRoom() {
    return this.room;
  }
  /** The arguments passed into the command. */ getArguments() {
    return this.params;
  }
  getThreadId() {
    return this.threadId;
  }
  getTriggerId() {
    return this.triggerId;
  }
}
//# sourceMappingURL=data:application/json;base64,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