const PrivateManager = Symbol('RoomPrivateManager');
export class Room {
  id;
  displayName;
  slugifiedName;
  type;
  creator;
  isDefault;
  isReadOnly;
  displaySystemMessages;
  messageCount;
  createdAt;
  updatedAt;
  lastModifiedAt;
  customFields;
  userIds;
  _USERNAMES;
  [PrivateManager];
  /**
	 * @deprecated
	 */ get usernames() {
    // Get usernames
    if (!this._USERNAMES) {
      this._USERNAMES = this[PrivateManager].getBridges().getInternalBridge().doGetUsernamesOfRoomByIdSync(this.id);
    }
    return this._USERNAMES;
  }
  set usernames(usernames) {}
  constructor(room, manager){
    Object.assign(this, room);
    Object.defineProperty(this, PrivateManager, {
      configurable: false,
      enumerable: false,
      writable: false,
      value: manager
    });
  }
  get value() {
    return {
      id: this.id,
      displayName: this.displayName,
      slugifiedName: this.slugifiedName,
      type: this.type,
      creator: this.creator,
      isDefault: this.isDefault,
      isReadOnly: this.isReadOnly,
      displaySystemMessages: this.displaySystemMessages,
      messageCount: this.messageCount,
      createdAt: this.createdAt,
      updatedAt: this.updatedAt,
      lastModifiedAt: this.lastModifiedAt,
      customFields: this.customFields,
      userIds: this.userIds
    };
  }
  async getUsernames() {
    // Get usernames
    if (!this._USERNAMES) {
      this._USERNAMES = await this[PrivateManager].getBridges().getInternalBridge().doGetUsernamesOfRoomById(this.id);
    }
    return this._USERNAMES;
  }
  toJSON() {
    return this.value;
  }
  toString() {
    return this.value;
  }
  valueOf() {
    return this.value;
  }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbGU6Ly8vaG9tZS9ydW5uZXIvd29yay9Sb2NrZXQuQ2hhdC9Sb2NrZXQuQ2hhdC9wYWNrYWdlcy9hcHBzLWVuZ2luZS9zcmMvc2VydmVyL3Jvb21zL1Jvb20udHMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHR5cGUgeyBJUm9vbSwgUm9vbVR5cGUgfSBmcm9tICcuLi8uLi9kZWZpbml0aW9uL3Jvb21zJztcbmltcG9ydCB0eXBlIHsgSVVzZXIgfSBmcm9tICcuLi8uLi9kZWZpbml0aW9uL3VzZXJzJztcbmltcG9ydCB0eXBlIHsgQXBwTWFuYWdlciB9IGZyb20gJy4uL0FwcE1hbmFnZXInO1xuXG5jb25zdCBQcml2YXRlTWFuYWdlciA9IFN5bWJvbCgnUm9vbVByaXZhdGVNYW5hZ2VyJyk7XG5cbmV4cG9ydCBjbGFzcyBSb29tIGltcGxlbWVudHMgSVJvb20ge1xuXHRwdWJsaWMgaWQ6IHN0cmluZztcblxuXHRwdWJsaWMgZGlzcGxheU5hbWU/OiBzdHJpbmc7XG5cblx0cHVibGljIHNsdWdpZmllZE5hbWU6IHN0cmluZztcblxuXHRwdWJsaWMgdHlwZTogUm9vbVR5cGU7XG5cblx0cHVibGljIGNyZWF0b3I6IElVc2VyO1xuXG5cdHB1YmxpYyBpc0RlZmF1bHQ/OiBib29sZWFuO1xuXG5cdHB1YmxpYyBpc1JlYWRPbmx5PzogYm9vbGVhbjtcblxuXHRwdWJsaWMgZGlzcGxheVN5c3RlbU1lc3NhZ2VzPzogYm9vbGVhbjtcblxuXHRwdWJsaWMgbWVzc2FnZUNvdW50PzogbnVtYmVyO1xuXG5cdHB1YmxpYyBjcmVhdGVkQXQ/OiBEYXRlO1xuXG5cdHB1YmxpYyB1cGRhdGVkQXQ/OiBEYXRlO1xuXG5cdHB1YmxpYyBsYXN0TW9kaWZpZWRBdD86IERhdGU7XG5cblx0cHVibGljIGN1c3RvbUZpZWxkcz86IHsgW2tleTogc3RyaW5nXTogYW55IH07XG5cblx0cHVibGljIHVzZXJJZHM/OiBBcnJheTxzdHJpbmc+O1xuXG5cdHByaXZhdGUgX1VTRVJOQU1FUzogQXJyYXk8c3RyaW5nPjtcblxuXHRwcml2YXRlIFtQcml2YXRlTWFuYWdlcl06IEFwcE1hbmFnZXI7XG5cblx0LyoqXG5cdCAqIEBkZXByZWNhdGVkXG5cdCAqL1xuXHRwdWJsaWMgZ2V0IHVzZXJuYW1lcygpOiBBcnJheTxzdHJpbmc+IHtcblx0XHQvLyBHZXQgdXNlcm5hbWVzXG5cdFx0aWYgKCF0aGlzLl9VU0VSTkFNRVMpIHtcblx0XHRcdHRoaXMuX1VTRVJOQU1FUyA9IHRoaXNbUHJpdmF0ZU1hbmFnZXJdLmdldEJyaWRnZXMoKS5nZXRJbnRlcm5hbEJyaWRnZSgpLmRvR2V0VXNlcm5hbWVzT2ZSb29tQnlJZFN5bmModGhpcy5pZCk7XG5cdFx0fVxuXG5cdFx0cmV0dXJuIHRoaXMuX1VTRVJOQU1FUztcblx0fVxuXG5cdHB1YmxpYyBzZXQgdXNlcm5hbWVzKHVzZXJuYW1lcykge31cblxuXHRwdWJsaWMgY29uc3RydWN0b3Iocm9vbTogSVJvb20sIG1hbmFnZXI6IEFwcE1hbmFnZXIpIHtcblx0XHRPYmplY3QuYXNzaWduKHRoaXMsIHJvb20pO1xuXG5cdFx0T2JqZWN0LmRlZmluZVByb3BlcnR5KHRoaXMsIFByaXZhdGVNYW5hZ2VyLCB7XG5cdFx0XHRjb25maWd1cmFibGU6IGZhbHNlLFxuXHRcdFx0ZW51bWVyYWJsZTogZmFsc2UsXG5cdFx0XHR3cml0YWJsZTogZmFsc2UsXG5cdFx0XHR2YWx1ZTogbWFuYWdlcixcblx0XHR9KTtcblx0fVxuXG5cdGdldCB2YWx1ZSgpOiBvYmplY3Qge1xuXHRcdHJldHVybiB7XG5cdFx0XHRpZDogdGhpcy5pZCxcblx0XHRcdGRpc3BsYXlOYW1lOiB0aGlzLmRpc3BsYXlOYW1lLFxuXHRcdFx0c2x1Z2lmaWVkTmFtZTogdGhpcy5zbHVnaWZpZWROYW1lLFxuXHRcdFx0dHlwZTogdGhpcy50eXBlLFxuXHRcdFx0Y3JlYXRvcjogdGhpcy5jcmVhdG9yLFxuXHRcdFx0aXNEZWZhdWx0OiB0aGlzLmlzRGVmYXVsdCxcblx0XHRcdGlzUmVhZE9ubHk6IHRoaXMuaXNSZWFkT25seSxcblx0XHRcdGRpc3BsYXlTeXN0ZW1NZXNzYWdlczogdGhpcy5kaXNwbGF5U3lzdGVtTWVzc2FnZXMsXG5cdFx0XHRtZXNzYWdlQ291bnQ6IHRoaXMubWVzc2FnZUNvdW50LFxuXHRcdFx0Y3JlYXRlZEF0OiB0aGlzLmNyZWF0ZWRBdCxcblx0XHRcdHVwZGF0ZWRBdDogdGhpcy51cGRhdGVkQXQsXG5cdFx0XHRsYXN0TW9kaWZpZWRBdDogdGhpcy5sYXN0TW9kaWZpZWRBdCxcblx0XHRcdGN1c3RvbUZpZWxkczogdGhpcy5jdXN0b21GaWVsZHMsXG5cdFx0XHR1c2VySWRzOiB0aGlzLnVzZXJJZHMsXG5cdFx0fTtcblx0fVxuXG5cdHB1YmxpYyBhc3luYyBnZXRVc2VybmFtZXMoKTogUHJvbWlzZTxBcnJheTxzdHJpbmc+PiB7XG5cdFx0Ly8gR2V0IHVzZXJuYW1lc1xuXHRcdGlmICghdGhpcy5fVVNFUk5BTUVTKSB7XG5cdFx0XHR0aGlzLl9VU0VSTkFNRVMgPSBhd2FpdCB0aGlzW1ByaXZhdGVNYW5hZ2VyXS5nZXRCcmlkZ2VzKCkuZ2V0SW50ZXJuYWxCcmlkZ2UoKS5kb0dldFVzZXJuYW1lc09mUm9vbUJ5SWQodGhpcy5pZCk7XG5cdFx0fVxuXG5cdFx0cmV0dXJuIHRoaXMuX1VTRVJOQU1FUztcblx0fVxuXG5cdHB1YmxpYyB0b0pTT04oKSB7XG5cdFx0cmV0dXJuIHRoaXMudmFsdWU7XG5cdH1cblxuXHRwdWJsaWMgdG9TdHJpbmcoKSB7XG5cdFx0cmV0dXJuIHRoaXMudmFsdWU7XG5cdH1cblxuXHRwdWJsaWMgdmFsdWVPZigpIHtcblx0XHRyZXR1cm4gdGhpcy52YWx1ZTtcblx0fVxufVxuIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUlBLE1BQU0saUJBQWlCLE9BQU87QUFFOUIsT0FBTyxNQUFNO0VBQ0wsR0FBVztFQUVYLFlBQXFCO0VBRXJCLGNBQXNCO0VBRXRCLEtBQWU7RUFFZixRQUFlO0VBRWYsVUFBb0I7RUFFcEIsV0FBcUI7RUFFckIsc0JBQWdDO0VBRWhDLGFBQXNCO0VBRXRCLFVBQWlCO0VBRWpCLFVBQWlCO0VBRWpCLGVBQXNCO0VBRXRCLGFBQXNDO0VBRXRDLFFBQXdCO0VBRXZCLFdBQTBCO0VBRTFCLENBQUMsZUFBZSxDQUFhO0VBRXJDOztFQUVDLEdBQ0QsSUFBVyxZQUEyQjtJQUNyQyxnQkFBZ0I7SUFDaEIsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7TUFDckIsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDLFVBQVUsR0FBRyxpQkFBaUIsR0FBRyw0QkFBNEIsQ0FBQyxJQUFJLENBQUMsRUFBRTtJQUM3RztJQUVBLE9BQU8sSUFBSSxDQUFDLFVBQVU7RUFDdkI7RUFFQSxJQUFXLFVBQVUsU0FBUyxFQUFFLENBQUM7RUFFakMsWUFBbUIsSUFBVyxFQUFFLE9BQW1CLENBQUU7SUFDcEQsT0FBTyxNQUFNLENBQUMsSUFBSSxFQUFFO0lBRXBCLE9BQU8sY0FBYyxDQUFDLElBQUksRUFBRSxnQkFBZ0I7TUFDM0MsY0FBYztNQUNkLFlBQVk7TUFDWixVQUFVO01BQ1YsT0FBTztJQUNSO0VBQ0Q7RUFFQSxJQUFJLFFBQWdCO0lBQ25CLE9BQU87TUFDTixJQUFJLElBQUksQ0FBQyxFQUFFO01BQ1gsYUFBYSxJQUFJLENBQUMsV0FBVztNQUM3QixlQUFlLElBQUksQ0FBQyxhQUFhO01BQ2pDLE1BQU0sSUFBSSxDQUFDLElBQUk7TUFDZixTQUFTLElBQUksQ0FBQyxPQUFPO01BQ3JCLFdBQVcsSUFBSSxDQUFDLFNBQVM7TUFDekIsWUFBWSxJQUFJLENBQUMsVUFBVTtNQUMzQix1QkFBdUIsSUFBSSxDQUFDLHFCQUFxQjtNQUNqRCxjQUFjLElBQUksQ0FBQyxZQUFZO01BQy9CLFdBQVcsSUFBSSxDQUFDLFNBQVM7TUFDekIsV0FBVyxJQUFJLENBQUMsU0FBUztNQUN6QixnQkFBZ0IsSUFBSSxDQUFDLGNBQWM7TUFDbkMsY0FBYyxJQUFJLENBQUMsWUFBWTtNQUMvQixTQUFTLElBQUksQ0FBQyxPQUFPO0lBQ3RCO0VBQ0Q7RUFFQSxNQUFhLGVBQXVDO0lBQ25ELGdCQUFnQjtJQUNoQixJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRTtNQUNyQixJQUFJLENBQUMsVUFBVSxHQUFHLE1BQU0sSUFBSSxDQUFDLGVBQWUsQ0FBQyxVQUFVLEdBQUcsaUJBQWlCLEdBQUcsd0JBQXdCLENBQUMsSUFBSSxDQUFDLEVBQUU7SUFDL0c7SUFFQSxPQUFPLElBQUksQ0FBQyxVQUFVO0VBQ3ZCO0VBRU8sU0FBUztJQUNmLE9BQU8sSUFBSSxDQUFDLEtBQUs7RUFDbEI7RUFFTyxXQUFXO0lBQ2pCLE9BQU8sSUFBSSxDQUFDLEtBQUs7RUFDbEI7RUFFTyxVQUFVO0lBQ2hCLE9BQU8sSUFBSSxDQUFDLEtBQUs7RUFDbEI7QUFDRCJ9