"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Api = void 0;
class Api {
    constructor() {
        this.services = new Set();
    }
    // set a broker for the API and registers all services in the broker
    setBroker(broker) {
        this.broker = broker;
        this.services.forEach((service) => this.broker?.createService(service));
    }
    async destroyService(instance) {
        if (!this.services.has(instance)) {
            return;
        }
        if (this.broker) {
            await this.broker.destroyService(instance);
        }
        this.services.delete(instance);
    }
    registerService(instance, serviceDependencies) {
        this.services.add(instance);
        instance.setApi(this);
        if (this.broker) {
            this.broker.createService(instance, serviceDependencies);
        }
    }
    async call(method, data, options) {
        return this.broker?.call(method, data, options);
    }
    async broadcast(event, ...args) {
        if (!this.broker) {
            throw new Error(`No broker set to broadcast: ${event}, ${JSON.stringify(args)}`);
        }
        return this.broker.broadcast(event, ...args);
    }
    async broadcastToServices(services, event, ...args) {
        return this.broker?.broadcastToServices(services, event, ...args);
    }
    async broadcastLocal(event, ...args) {
        return this.broker?.broadcastLocal(event, ...args);
    }
    nodeList() {
        if (!this.broker) {
            throw new Error('No broker set to start.');
        }
        return this.broker.nodeList();
    }
    async start() {
        if (!this.broker) {
            throw new Error('No broker set to start.');
        }
        await this.broker.start();
    }
}
exports.Api = Api;
//# sourceMappingURL=Api.js.map