"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getConnection = void 0;
exports.getTrashCollection = getTrashCollection;
const tracing_1 = require("@rocket.chat/tracing");
const mongodb_1 = require("mongodb");
const { MONGO_URL = 'mongodb://localhost:27017/rocketchat' } = process.env;
const name = /^mongodb:\/\/.*?(?::[0-9]+)?\/([^?]*)/.exec(MONGO_URL)?.[1];
function connectDb(options) {
    const client = new mongodb_1.MongoClient(MONGO_URL, {
        ...options,
        monitorCommands: (0, tracing_1.isTracingEnabled)(),
    });
    return client.connect().catch((error) => {
        // exits the process in case of any error
        console.error(error);
        process.exit(1);
    });
}
let db;
exports.getConnection = (() => {
    let client;
    return async (options) => {
        if (db) {
            return { db, client };
        }
        if (client == null) {
            client = await connectDb(options);
            db = client.db(name);
        }
        // if getConnection was called multiple times before it was connected, wait for the connection
        return { client, db: client.db(name) };
    };
})();
async function getTrashCollection() {
    if (!db) {
        const { db: clientDb } = await (0, exports.getConnection)();
        db = clientDb;
    }
    return db.collection('rocketchat__trash');
}
//# sourceMappingURL=mongo.js.map