"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWellKnownRoutes = void 0;
const http_router_1 = require("@rocket.chat/http-router");
const Ajv_1 = require("@rocket.chat/rest-typings/dist/v1/Ajv");
const node_crypto_1 = require("node:crypto");
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const WellKnownServerResponseSchema = {
    type: 'object',
    properties: {
        'm.server': {
            type: 'string',
            description: 'Matrix server address with port',
        },
    },
    required: ['m.server'],
};
const isWellKnownServerResponseProps = Ajv_1.ajv.compile(WellKnownServerResponseSchema);
// TODO: After changing the domain setting this route is still reporting the old domain until the server is restarted
// TODO: this is wrong, is siteurl !== domain this path should return 404. this path is to discover the final address, domain being the "proxy" and siteurl the final destination, if domain is different, well-known should be served there, not here.
const getWellKnownRoutes = () => {
    return new http_router_1.Router('/matrix').get('/server', {
        response: {
            200: isWellKnownServerResponseProps,
        },
        tags: ['Well-Known'],
        license: ['federation'],
    }, async (c) => {
        const responseData = federation_sdk_1.federationSDK.getWellKnownHostData();
        const etag = (0, node_crypto_1.createHash)('md5').update(JSON.stringify(responseData)).digest('hex');
        c.header('ETag', etag);
        c.header('Content-Type', 'application/json');
        return {
            body: responseData,
            statusCode: 200,
        };
    });
};
exports.getWellKnownRoutes = getWellKnownRoutes;
//# sourceMappingURL=server.js.map