"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFederationVersionsRoutes = void 0;
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const http_router_1 = require("@rocket.chat/http-router");
const Ajv_1 = require("@rocket.chat/rest-typings/dist/v1/Ajv");
const GetVersionsResponseSchema = {
    type: 'object',
    properties: {
        server: {
            type: 'object',
            properties: {
                name: {
                    type: 'string',
                    description: 'Server software name',
                },
                version: {
                    type: 'string',
                    description: 'Server software version',
                },
            },
            required: ['name', 'version'],
        },
    },
    required: ['server'],
};
const isGetVersionsResponseProps = Ajv_1.ajv.compile(GetVersionsResponseSchema);
const getFederationVersionsRoutes = () => {
    return new http_router_1.Router('/federation').get('/v1/version', {
        response: {
            200: isGetVersionsResponseProps,
        },
        tags: ['Federation'],
        license: ['federation'],
    }, async () => {
        const serverName = federation_sdk_1.federationSDK.getConfig('serverName');
        const version = federation_sdk_1.federationSDK.getConfig('version');
        const response = {
            server: {
                name: serverName,
                version,
            },
        };
        return {
            body: response,
            statusCode: 200,
        };
    });
};
exports.getFederationVersionsRoutes = getFederationVersionsRoutes;
//# sourceMappingURL=versions.js.map