"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.canAccessResourceMiddleware = void 0;
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const combine_1 = require("hono/combine");
const factory_1 = require("hono/factory");
const isAuthenticated_1 = require("./isAuthenticated");
function extractEntityId(params, entityType) {
    if (entityType === 'room') {
        return params.roomId ?? null;
    }
    if (entityType === 'media') {
        return params.mediaId ?? null;
    }
    if (entityType === 'event') {
        return params.eventId ?? null;
    }
    return null;
}
const canAccessResource = (entityType) => (0, factory_1.createMiddleware)(async (c, next) => {
    try {
        const mediaId = c.req.param('mediaId');
        const eventId = c.req.param('eventId');
        const roomId = c.req.param('roomId');
        const resourceId = extractEntityId({ mediaId, eventId, roomId }, entityType);
        if (!resourceId) {
            return c.json({ errcode: 'M_INVALID_PARAM', error: `Missing required ${entityType} identifier` }, 400);
        }
        const resourceAccess = await federation_sdk_1.federationSDK.canAccessResource(entityType, resourceId, c.get('authenticatedServer'));
        if (!resourceAccess) {
            return c.json({
                errcode: 'M_FORBIDDEN',
                error: 'Access denied to resource',
            }, 403);
        }
        return next();
    }
    catch (error) {
        return c.json(federation_sdk_1.errCodes.M_UNKNOWN, 500);
    }
});
const canAccessResourceMiddleware = (entityType) => (0, combine_1.every)((0, isAuthenticated_1.isAuthenticatedMiddleware)(), canAccessResource(entityType));
exports.canAccessResourceMiddleware = canAccessResourceMiddleware;
//# sourceMappingURL=canAccessResource.js.map