"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAuthenticatedMiddleware = void 0;
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const factory_1 = require("hono/factory");
const isAuthenticatedMiddleware = () => (0, factory_1.createMiddleware)(async (c, next) => {
    try {
        const { method } = c.req;
        const body = c.req.raw.body ? await c.req.raw.clone().json() : undefined;
        const url = new URL(c.req.url);
        const path = url.pathname + url.search;
        const authHeader = c.req.header('Authorization') || '';
        if (!authHeader) {
            return c.json({
                errcode: 'M_UNAUTHORIZED',
                error: 'Missing Authorization header',
            }, 401);
        }
        const verificationResult = await federation_sdk_1.federationSDK.verifyRequestSignature(authHeader, method, path, body);
        if (!verificationResult) {
            return c.json({
                errcode: federation_sdk_1.errCodes.M_UNAUTHORIZED.errcode,
                error: federation_sdk_1.errCodes.M_UNAUTHORIZED.error,
            }, federation_sdk_1.errCodes.M_UNAUTHORIZED.status);
        }
        c.set('authenticatedServer', verificationResult);
        return next();
    }
    catch (error) {
        return c.json(federation_sdk_1.errCodes.M_UNKNOWN, 500);
    }
});
exports.isAuthenticatedMiddleware = isAuthenticatedMiddleware;
//# sourceMappingURL=isAuthenticated.js.map