"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.edus = void 0;
const core_services_1 = require("@rocket.chat/core-services");
const core_typings_1 = require("@rocket.chat/core-typings");
const federation_sdk_1 = require("@rocket.chat/federation-sdk");
const logger_1 = require("@rocket.chat/logger");
const models_1 = require("@rocket.chat/models");
const logger = new logger_1.Logger('federation-matrix:edu');
const edus = async (emitter) => {
    emitter.on('homeserver.matrix.typing', async (data) => {
        const config = federation_sdk_1.federationSDK.getConfig('edu');
        if (!config.processTyping) {
            return;
        }
        try {
            const matrixRoom = await models_1.Rooms.findOne({ 'federation.mrid': data.room_id }, { projection: { _id: 1 } });
            if (!matrixRoom) {
                logger.debug(`No bridged room found for Matrix room_id: ${data.room_id}`);
                return;
            }
            void core_services_1.api.broadcast('user.activity', {
                user: data.user_id,
                isTyping: data.typing,
                roomId: matrixRoom._id,
            });
        }
        catch (error) {
            logger.error('Error handling Matrix typing event:', error);
        }
    });
    emitter.on('homeserver.matrix.presence', async (data) => {
        const config = federation_sdk_1.federationSDK.getConfig('edu');
        if (!config.processPresence) {
            return;
        }
        try {
            const matrixUser = await models_1.Users.findOneByUsername(data.user_id);
            if (!matrixUser) {
                logger.debug(`No federated user found for Matrix user_id: ${data.user_id}`);
                return;
            }
            if (!matrixUser.federated) {
                logger.debug(`User ${matrixUser.username} is not federated, skipping presence update from Matrix`);
                return;
            }
            const statusMap = {
                online: core_typings_1.UserStatus.ONLINE,
                offline: core_typings_1.UserStatus.OFFLINE,
                unavailable: core_typings_1.UserStatus.AWAY,
            };
            const status = statusMap[data.presence] || core_typings_1.UserStatus.OFFLINE;
            if (matrixUser.status === status) {
                logger.debug(`User ${matrixUser.username} already has status ${status}, skipping update`);
                return;
            }
            await models_1.Users.updateOne({ _id: matrixUser._id }, {
                $set: {
                    status,
                    statusDefault: status,
                },
            });
            const { _id, username, statusText, roles, name } = matrixUser;
            void core_services_1.api.broadcast('presence.status', {
                user: { status, _id, username, statusText, roles, name },
                previousStatus: undefined,
            });
            logger.debug(`Updated presence for user ${matrixUser._id} to ${status} from Matrix federation`);
        }
        catch (error) {
            logger.error('Error handling Matrix presence event:', error);
        }
    });
};
exports.edus = edus;
//# sourceMappingURL=edu.js.map