"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.reaction = reaction;
const core_services_1 = require("@rocket.chat/core-services");
const logger_1 = require("@rocket.chat/logger");
const models_1 = require("@rocket.chat/models"); // Rooms
const emojione_1 = __importDefault(require("emojione"));
const logger = new logger_1.Logger('federation-matrix:reaction');
function reaction(emitter) {
    emitter.on('homeserver.matrix.reaction', async ({ event, event_id: eventId }) => {
        try {
            const isSetReaction = event.content?.['m.relates_to'];
            const reactionTargetEventId = isSetReaction?.event_id;
            const reactionKey = isSetReaction?.key;
            const [userPart, domain] = event.sender.split(':');
            if (!userPart || !domain) {
                logger.error('Invalid Matrix sender ID format:', event.sender);
                return;
            }
            const internalUsername = event.sender;
            const user = await models_1.Users.findOneByUsername(internalUsername);
            if (!user) {
                logger.error(`No RC user mapping found for Matrix event ${reactionTargetEventId} ${internalUsername}`);
                return;
            }
            if (!isSetReaction) {
                logger.debug(`No relates_to content in reaction event`);
                return;
            }
            const rcMessage = await models_1.Messages.findOneByFederationId(reactionTargetEventId);
            if (!rcMessage) {
                logger.debug(`No RC message mapping found for Matrix event ${reactionTargetEventId}`);
                return;
            }
            const reactionEmoji = emojione_1.default.toShort(reactionKey);
            await core_services_1.Message.reactToMessage(user._id, reactionEmoji, rcMessage._id, true);
            await models_1.Messages.setFederationReactionEventId(internalUsername, rcMessage._id, reactionEmoji, eventId);
        }
        catch (error) {
            logger.error('Failed to process Matrix reaction:', error);
        }
    });
    emitter.on('homeserver.matrix.redaction', async ({ event }) => {
        try {
            const redactedEventId = event.redacts;
            if (!redactedEventId) {
                logger.debug('No redacts field in redaction event');
                return;
            }
            const reactionEvent = await core_services_1.FederationMatrix.getEventById(redactedEventId);
            if (!reactionEvent || reactionEvent.event.type !== 'm.reaction') {
                logger.debug(`Event ${redactedEventId} is not a reaction event`);
                return;
            }
            const reactionContent = reactionEvent.event.content?.['m.relates_to'];
            if (!reactionContent) {
                logger.debug('No relates_to content in reaction event');
                return;
            }
            const targetMessageEventId = reactionContent.event_id;
            const reactionKey = reactionContent.key;
            const rcMessage = await models_1.Messages.findOneByFederationId(targetMessageEventId);
            if (!rcMessage) {
                logger.debug(`No RC message found for event ${targetMessageEventId}`);
                return;
            }
            const internalUsername = event.sender;
            const user = await models_1.Users.findOneByUsername(internalUsername);
            if (!user) {
                logger.debug(`User not found: ${internalUsername}`);
                return;
            }
            const reactionEmoji = emojione_1.default.toShort(reactionKey);
            await core_services_1.Message.reactToMessage(user._id, reactionEmoji, rcMessage._id, false);
            await models_1.Messages.unsetFederationReactionEventId(redactedEventId, rcMessage._id, reactionEmoji);
        }
        catch (error) {
            logger.error('Failed to process Matrix reaction redaction:', error);
        }
    });
}
//# sourceMappingURL=reaction.js.map