"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCommandGetDomain = getCommandGetDomain;
exports.parseDomainResponse = parseDomainResponse;
exports.getDomain = getDomain;
const esl_1 = require("../esl");
const logger_1 = require("../logger");
function getCommandGetDomain() {
    return 'eval ${domain}';
}
function parseDomainResponse(response) {
    const { _body: domain } = response;
    if (typeof domain !== 'string') {
        logger_1.logger.error({ msg: 'Failed to load user domain', response });
        throw new Error('Failed to load user domain from FreeSwitch.');
    }
    return domain;
}
async function getDomain(options) {
    const response = await esl_1.FreeSwitchApiClient.runSingleCommand(options, getCommandGetDomain());
    return parseDomainResponse(response);
}
//# sourceMappingURL=getDomain.js.map