"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCommandListUsers = getCommandListUsers;
exports.getExtensionList = getExtensionList;
const esl_1 = require("../esl");
const mapUserData_1 = require("../utils/mapUserData");
const parseUserList_1 = require("../utils/parseUserList");
function getCommandListUsers() {
    return 'list_users';
}
async function getExtensionList(options) {
    const response = await esl_1.FreeSwitchApiClient.runSingleCommand(options, getCommandListUsers());
    const users = (0, parseUserList_1.parseUserList)(response);
    return users.map((item) => (0, mapUserData_1.mapUserData)(item));
}
//# sourceMappingURL=getExtensionList.js.map