"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FreeSwitchEventClient = void 0;
const logger_1 = require("../logger");
const client_1 = require("./client");
const eventsToListen = [
    'CHANNEL_CALLSTATE',
    'CHANNEL_STATE',
    'CHANNEL_CREATE',
    'CHANNEL_DESTROY',
    'CHANNEL_ANSWER',
    'CHANNEL_HANGUP',
    'CHANNEL_HANGUP_COMPLETE',
    'CHANNEL_BRIDGE',
    'CHANNEL_UNBRIDGE',
    'CHANNEL_OUTGOING',
    'CHANNEL_PARK',
    'CHANNEL_UNPARK',
    'CHANNEL_HOLD',
    'CHANNEL_UNHOLD',
    'CHANNEL_ORIGINATE',
    'CHANNEL_UUID',
    'CHANNEL_APPLICATION',
    'CHANNEL_PROGRESS',
    'CHANNEL_PROGRESS_MEDIA',
    'CALL_UPDATE',
];
class FreeSwitchEventClient extends client_1.FreeSwitchESLClient {
    constructor(options, eventsToListen) {
        super(options);
        this.options = options;
        this.eventsToListen = eventsToListen;
        eventsToListen.forEach((eventName) => {
            this.response.on(eventName, (eventData) => this.emit('event', { eventName, eventData: eventData.body }));
        });
    }
    async transitionToReady() {
        try {
            this.response.event_json(...this.eventsToListen);
        }
        catch (error) {
            logger_1.logger.error({ msg: 'Failed to request events', error });
            throw new Error('failed-to-request-events');
        }
        super.transitionToReady();
    }
    static listenToEvents(options) {
        return new FreeSwitchEventClient(options, eventsToListen);
    }
}
exports.FreeSwitchEventClient = FreeSwitchEventClient;
//# sourceMappingURL=eventClient.js.map