"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseEventLeg = parseEventLeg;
const filterOutMissingData_1 = require("./filterOutMissingData");
const filterStringList_1 = require("./filterStringList");
const parseTimestamp_1 = require("./parseTimestamp");
function parseEventLeg(legName, eventData) {
    const legData = (0, filterStringList_1.filterStringList)(eventData, (key) => key.startsWith(`${legName}-`), ([key, value]) => {
        return [key.replace(`${legName}-`, ''), value];
    });
    const legType = legName === 'Other-Leg' ? eventData['Other-Type'] : undefined;
    const { 'Direction': direction, 'Logical-Direction': logicalDirection, 'Username': username, 'Caller-ID-Name': callerName, 'Caller-ID-Number': callerNumber, 'Orig-Caller-ID-Name': originalCallerName, 'Orig-Caller-ID-Number': originalCallerNumber, 'Callee-ID-Name': calleeName, 'Callee-ID-Number': calleeNumber, 'Network-Addr': networkAddress, 'Destination-Number': destinationNumber, 'Unique-ID': uniqueId, 'Source': source, 'Context': context, 'Channel-Name': channelName, 'Dialplan': dialplan, 'Profile-Index': profileIndex, 'ANI': ani, 'RDNIS': rdnis, 'Transfer-Source': transferSource, 'Screen-Bit': screenBit, 'Privacy-Hide-Name': privacyHideName, 'Privacy-Hide-Number': privacyHideNumber, 'Profile-Created-Time': profileCreatedTime, 'Channel-Created-Time': channelCreatedTime, 'Channel-Answered-Time': channelAnsweredTime, 'Channel-Progress-Time': channelProgressTime, 'Channel-Bridged-Time': channelBridgedTime, 'Channel-Progress-Media-Time': channelProgressMediaTime, 'Channel-Hangup-Time': channelHangupTime, 'Channel-Transfer-Time': channelTransferTime, 'Channel-Resurrect-Time': channelRessurectTime, 'Channel-Last-Hold': channelLastHold, ...rawLegData } = legData;
    if (!uniqueId) {
        return;
    }
    const profile = {
        ...(0, filterOutMissingData_1.filterOutMissingData)({
            profileIndex,
            profileCreatedTime: (0, parseTimestamp_1.parseTimestamp)(profileCreatedTime),
            channelCreatedTime: (0, parseTimestamp_1.parseTimestamp)(channelCreatedTime),
            channelAnsweredTime: (0, parseTimestamp_1.parseTimestamp)(channelAnsweredTime),
            channelProgressTime: (0, parseTimestamp_1.parseTimestamp)(channelProgressTime),
            channelBridgedTime: (0, parseTimestamp_1.parseTimestamp)(channelBridgedTime),
            channelProgressMediaTime: (0, parseTimestamp_1.parseTimestamp)(channelProgressMediaTime),
            channelHangupTime: (0, parseTimestamp_1.parseTimestamp)(channelHangupTime),
            channelTransferTime: (0, parseTimestamp_1.parseTimestamp)(channelTransferTime),
            channelRessurectTime: (0, parseTimestamp_1.parseTimestamp)(channelRessurectTime),
            channelLastHold: (0, parseTimestamp_1.parseTimestamp)(channelLastHold),
        }),
    };
    const effectiveProfileIndex = profileIndex || '1';
    const leg = {
        legName,
        uniqueId,
        type: legType,
        direction,
        logicalDirection,
        username,
        callerName,
        callerNumber,
        originalCallerName,
        originalCallerNumber,
        calleeName,
        calleeNumber,
        networkAddress,
        destinationNumber,
        source,
        context,
        channelName,
        transferSource,
        // If there's no profileIndex, default to '1', but do not save a profile if there's nothing in it
        ...(Object.keys(profile).length > 0 && { profiles: { [effectiveProfileIndex]: { ...profile, profileIndex: effectiveProfileIndex } } }),
        dialplan,
        ani,
        rdnis,
        screenBit,
        privacyHideName,
        privacyHideNumber,
        raw: (0, filterOutMissingData_1.filterOutMissingData)(rawLegData),
    };
    return (0, filterOutMissingData_1.filterOutMissingData)(leg);
}
//# sourceMappingURL=parseEventLeg.js.map