"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RadioButton = exports.ToggleSwitch = exports.CheckBox = exports.Select = exports.UrlInput = exports.NumberInput = exports.TelephoneInput = exports.TextAreaInput = exports.SearchInput = exports.PasswordInput = exports.EmailInput = exports.TextInput = void 0;
var fuselage_1 = require("@rocket.chat/fuselage");
var withLabelHelpers_1 = require("./withLabelHelpers");
// TODO: Some inputs are still not supported due to requiring a different a11y approach
// with id
exports.TextInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.TextInput);
exports.EmailInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.EmailInput);
exports.PasswordInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.PasswordInput);
exports.SearchInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.SearchInput);
exports.TextAreaInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.TextAreaInput);
exports.TelephoneInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.TelephoneInput);
exports.NumberInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.NumberInput);
exports.UrlInput = (0, withLabelHelpers_1.withLabelId)(fuselage_1.UrlInput);
// with aria-labelledby
exports.Select = (0, withLabelHelpers_1.withAriaLabelledBy)(fuselage_1.Select);
// with visually hidden label
exports.CheckBox = (0, withLabelHelpers_1.withVisuallyHiddenLabel)(fuselage_1.CheckBox);
exports.ToggleSwitch = (0, withLabelHelpers_1.withVisuallyHiddenLabel)(fuselage_1.ToggleSwitch);
exports.RadioButton = (0, withLabelHelpers_1.withVisuallyHiddenLabel)(fuselage_1.RadioButton);
//# sourceMappingURL=WrappedInputComponents.js.map