import { TextInput as TextInputComponent, Select as SelectComponent, CheckBox as CheckBoxComponent, ToggleSwitch as ToggleSwitchComponent, RadioButton as RadioButtonComponent, EmailInput as EmailInputComponent, PasswordInput as PasswordInputComponent, SearchInput as SearchInputComponent, TextAreaInput as TextAreaComponent, NumberInput as NumberInputComponent, TelephoneInput as TelephoneInputComponent, UrlInput as UrlInputComponent, } from '@rocket.chat/fuselage';
import { withLabelId, withAriaLabelledBy, withVisuallyHiddenLabel, } from './withLabelHelpers';
// TODO: Some inputs are still not supported due to requiring a different a11y approach
// with id
export var TextInput = withLabelId(TextInputComponent);
export var EmailInput = withLabelId(EmailInputComponent);
export var PasswordInput = withLabelId(PasswordInputComponent);
export var SearchInput = withLabelId(SearchInputComponent);
export var TextAreaInput = withLabelId(TextAreaComponent);
export var TelephoneInput = withLabelId(TelephoneInputComponent);
export var NumberInput = withLabelId(NumberInputComponent);
export var UrlInput = withLabelId(UrlInputComponent);
// with aria-labelledby
export var Select = withAriaLabelledBy(SelectComponent);
// with visually hidden label
export var CheckBox = withVisuallyHiddenLabel(CheckBoxComponent);
export var ToggleSwitch = withVisuallyHiddenLabel(ToggleSwitchComponent);
export var RadioButton = withVisuallyHiddenLabel(RadioButtonComponent);
//# sourceMappingURL=WrappedInputComponents.js.map