import { memo, useLayoutEffect } from 'react';
import { createPortal } from 'react-dom';
var ensureAnchorElement = function (id) {
    var existingAnchor = document.getElementById(id);
    if (existingAnchor)
        return existingAnchor;
    var newAnchor = document.createElement('div');
    newAnchor.id = id;
    document.body.appendChild(newAnchor);
    return newAnchor;
};
var getAnchorRefCount = function (anchorElement) {
    var refCount = anchorElement.dataset.refCount;
    if (refCount)
        return parseInt(refCount, 10);
    return 0;
};
var setAnchorRefCount = function (anchorElement, refCount) {
    anchorElement.dataset.refCount = String(refCount);
};
var refAnchorElement = function (anchorElement) {
    setAnchorRefCount(anchorElement, getAnchorRefCount(anchorElement) + 1);
    if (anchorElement.parentElement !== document.body) {
        document.body.appendChild(anchorElement);
    }
};
var unrefAnchorElement = function (anchorElement) {
    var refCount = getAnchorRefCount(anchorElement) - 1;
    setAnchorRefCount(anchorElement, refCount);
    if (refCount <= 0) {
        document.body.removeChild(anchorElement);
    }
};
var ToastBarPortal = function (_a) {
    var children = _a.children;
    var toastBarRoot = ensureAnchorElement('toastBarRoot');
    useLayoutEffect(function () {
        refAnchorElement(toastBarRoot);
        return function () {
            unrefAnchorElement(toastBarRoot);
        };
    }, [toastBarRoot]);
    return createPortal(children, toastBarRoot);
};
export default memo(ToastBarPortal);
//# sourceMappingURL=ToastBarPortal.js.map