var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState, memo, useCallback } from 'react';
import { ToastBarContext } from './ToastBarContext';
import ToastBarPersistent from './ToastBarPersistent';
import ToastBarPortal from './ToastBarPortal';
import ToastBarTimed from './ToastBarTimed';
import ToastBarZone from './ToastBarZone';
var ToastBarProvider = function (_a) {
    var children = _a.children;
    var _b = useState([]), toasts = _b[0], setToasts = _b[1];
    var contextValue = {
        dispatch: useCallback(function (option) {
            return setToasts(function (toasts) { return __spreadArray(__spreadArray([], toasts, true), [
                __assign(__assign({}, option), { time: option.time || 5, id: Math.random().toString() }),
            ], false); });
        }, []),
        dismiss: useCallback(function (id) {
            return setToasts(function (prevState) { return prevState.filter(function (toast) { return toast.id !== id; }); });
        }, []),
    };
    return (_jsxs(ToastBarContext.Provider, { value: contextValue, children: [children, _jsx(ToastBarPortal, { children: Object.entries(toasts === null || toasts === void 0 ? void 0 : toasts.reduce(function (zones, toast) {
                    zones[toast.position || 'top-end'] =
                        zones[toast.position || 'top-end'] || [];
                    zones[toast.position || 'top-end'].push(toast);
                    return zones;
                }, {})).map(function (_a) {
                    var zone = _a[0], toasts = _a[1];
                    return (_jsx(ToastBarZone, { position: zone, children: toasts.map(function (toast) {
                            return toast.isPersistent ? (_jsx(ToastBarPersistent, __assign({}, toast), toast.id)) : (_jsx(ToastBarTimed, __assign({}, toast), toast.id));
                        }) }, zone));
                }) })] }));
};
export default memo(ToastBarProvider);
//# sourceMappingURL=ToastBarProvider.js.map