"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const core_typings_1 = require("@rocket.chat/core-typings");
const ui_contexts_1 = require("@rocket.chat/ui-contexts");
const ui_video_conf_1 = require("@rocket.chat/ui-video-conf");
const react_1 = require("react");
const __1 = require("../..");
const useVideoConfDataStream_1 = require("./hooks/useVideoConfDataStream");
const useSurfaceType_1 = require("../../hooks/useSurfaceType");
const MAX_USERS = 3;
const VideoConferenceBlock = ({ block }) => {
    var _a;
    const t = (0, ui_contexts_1.useTranslation)();
    const { callId, appId = 'videoconf-core' } = block;
    const surfaceType = (0, useSurfaceType_1.useSurfaceType)();
    const userId = (0, ui_contexts_1.useUserId)();
    const goToRoom = (0, ui_contexts_1.useGoToRoom)();
    const displayAvatars = (0, ui_contexts_1.useUserPreference)('displayAvatars');
    const showRealName = (0, ui_contexts_1.useSetting)('UI_Use_Real_Name', false);
    const { action, viewId = undefined, rid } = (0, react_1.useContext)(__1.UiKitContext);
    if (surfaceType !== 'message') {
        throw new Error('VideoConferenceBlock cannot be rendered outside message');
    }
    if (!rid) {
        throw new Error('VideoConferenceBlock cannot be rendered without rid');
    }
    const result = (0, useVideoConfDataStream_1.useVideoConfDataStream)({ rid, callId });
    const joinHandler = (e) => {
        action({
            blockId: block.blockId || '',
            appId,
            actionId: 'join',
            value: block.blockId || '',
            viewId,
        }, e);
    };
    const callAgainHandler = (e) => {
        action({
            blockId: rid || '',
            appId,
            actionId: 'callBack',
            value: rid || '',
            viewId,
        }, e);
    };
    const openCallInfo = (e) => {
        action({
            blockId: callId,
            appId,
            actionId: 'info',
            value: rid,
            viewId,
        }, e);
    };
    const openDiscussion = (_e) => {
        if (data.discussionRid) {
            goToRoom(data.discussionRid);
        }
    };
    const messageFooterText = (0, react_1.useMemo)(() => {
        var _a;
        const usersCount = (_a = result.data) === null || _a === void 0 ? void 0 : _a.users.length;
        if (!displayAvatars) {
            return t('__usersCount__joined', {
                count: usersCount,
            });
        }
        return usersCount && usersCount > MAX_USERS
            ? t('plus__usersCount__joined', {
                count: usersCount - MAX_USERS,
            })
            : t('joined');
    }, [displayAvatars, t, (_a = result.data) === null || _a === void 0 ? void 0 : _a.users.length]);
    if (result.isPending || result.isError) {
        // TODO: error handling
        return (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageSkeleton, {});
    }
    const { data } = result;
    const isUserCaller = data.createdBy._id === userId;
    const joinedNamesOrUsernames = [...data.users]
        .splice(0, MAX_USERS)
        .map(({ name, username }) => (0, core_typings_1.getUserDisplayName)(name, username, showRealName))
        .join(', ');
    const title = data.users.length > MAX_USERS
        ? t('__usernames__and__count__more_joined', {
            usernames: joinedNamesOrUsernames,
            count: data.users.length - MAX_USERS,
        })
        : t('__usernames__joined', { usernames: joinedNamesOrUsernames });
    const actions = ((0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageActions, { children: [data.discussionRid && (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageAction, { icon: 'discussion', title: t('Join_discussion'), onClick: openDiscussion }), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageAction, { icon: 'info', onClick: openCallInfo })] }));
    if ('endedAt' in data) {
        return ((0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessage, { children: [(0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageRow, { children: [(0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageContent, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageIcon, {}), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageText, { children: t('Call_ended') })] }), actions] }), (0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageFooter, { children: [data.type === 'direct' && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageButton, { onClick: callAgainHandler, children: isUserCaller ? t('Call_again') : t('Call_back') }), [core_typings_1.VideoConferenceStatus.EXPIRED, core_typings_1.VideoConferenceStatus.DECLINED].includes(data.status) && ((0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageFooterText, { children: t('Call_was_not_answered') }))] })), data.type !== 'direct' &&
                            (data.users.length ? ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageUserStack, { users: data.users }), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageFooterText, { title: title, children: messageFooterText })] })) : ([core_typings_1.VideoConferenceStatus.EXPIRED, core_typings_1.VideoConferenceStatus.DECLINED].includes(data.status) && ((0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageFooterText, { children: t('Call_was_not_answered') }))))] })] }));
    }
    if (data.type === 'direct' && data.status === core_typings_1.VideoConferenceStatus.CALLING) {
        return ((0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessage, { children: [(0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageRow, { children: [(0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageContent, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageIcon, { variant: 'incoming' }), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageText, { children: t('Calling') })] }), actions] }), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageFooter, { children: (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageFooterText, { children: t('Waiting_for_answer') }) })] }));
    }
    return ((0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessage, { children: [(0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageRow, { children: [(0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageContent, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageIcon, { variant: 'outgoing' }), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageText, { children: t('Call_ongoing') })] }), actions] }), (0, jsx_runtime_1.jsxs)(ui_video_conf_1.VideoConfMessageFooter, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageButton, { primary: true, onClick: joinHandler, children: t('Join') }), Boolean(data.users.length) && ((0, jsx_runtime_1.jsxs)(jsx_runtime_1.Fragment, { children: [(0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageUserStack, { users: data.users }), (0, jsx_runtime_1.jsx)(ui_video_conf_1.VideoConfMessageFooterText, { title: title, children: messageFooterText })] }))] })] }));
};
exports.default = (0, react_1.memo)(VideoConferenceBlock);
//# sourceMappingURL=VideoConferenceBlock.js.map