"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const jsx_runtime_1 = require("react/jsx-runtime");
const fuselage_1 = require("@rocket.chat/fuselage");
const useUiKitState_1 = require("../hooks/useUiKitState");
const IconButtonElement = ({ block, context }) => {
    const [{ loading }, action] = (0, useUiKitState_1.useUiKitState)(block, context);
    const { url, value, label, icon } = block;
    const { icon: iconName, variant } = icon;
    const handleClick = (e) => {
        action({ target: e.currentTarget });
    };
    if (url) {
        return (0, jsx_runtime_1.jsx)(fuselage_1.IconButton, { small: true, is: 'a', target: '_blank', disabled: loading, icon: iconName, href: url, onClick: handleClick, label: label });
    }
    return ((0, jsx_runtime_1.jsx)(fuselage_1.IconButton, { icon: iconName, color: variant === 'default' ? 'default' : 'danger', small: true, label: label, disabled: loading, value: value, onClick: handleClick }));
};
exports.default = IconButtonElement;
//# sourceMappingURL=IconButtonElement.js.map