import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Button } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { memo, useCallback, useMemo, useState } from 'react';
import Action from './ActionsBlock.Action';
import { useSurfaceType } from '../hooks/useSurfaceType';
const ActionsBlock = ({ className, block, surfaceRenderer }) => {
    const surfaceType = useSurfaceType();
    const [showMoreVisible, setShowMoreVisible] = useState(() => block.elements.length > 5 && surfaceType !== 'banner');
    const handleShowMoreClick = useCallback(() => {
        setShowMoreVisible(false);
    }, []);
    const actionElements = useMemo(() => (showMoreVisible ? block.elements.slice(0, 5) : block.elements).map((element) => {
        var _a, _b;
        return (Object.assign(Object.assign({}, element), { appId: (_a = element.appId) !== null && _a !== void 0 ? _a : block.appId, blockId: (_b = element.blockId) !== null && _b !== void 0 ? _b : block.blockId }));
    }), [block.appId, block.blockId, block.elements, showMoreVisible]);
    return (_jsxs(Box, { className: className, display: 'flex', flexWrap: 'wrap', margin: -4, children: [actionElements.map((element, i) => (_jsx(Action, { element: element, parser: surfaceRenderer, index: i }, i))), showMoreVisible && (_jsx(Box, { display: 'flex', margin: 4, children: _jsx(Button, { small: true, onClick: handleShowMoreClick, children: surfaceRenderer.renderTextObject({ type: 'plain_text', text: 'Show more...' }, 0, UiKit.BlockContext.NONE) }) }))] }));
};
export default memo(ActionsBlock);
//# sourceMappingURL=ActionsBlock.js.map