import { jsx as _jsx } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
const Item = ({ block: element, surfaceRenderer: parser, index }) => {
    const renderedElement = parser.renderContextBlockElement(element, index);
    if (!renderedElement) {
        return null;
    }
    switch (element.type) {
        case UiKit.TextObjectType.PLAIN_TEXT:
        case UiKit.TextObjectType.MARKDOWN:
            return (_jsx(Box, { is: 'span', fontScale: 'c1', color: 'hint', margin: 4, children: renderedElement }));
        default:
            return renderedElement;
    }
};
export default Item;
//# sourceMappingURL=ContextBlock.Item.js.map