import { jsx as _jsx } from "react/jsx-runtime";
import { Box } from '@rocket.chat/fuselage';
import { memo, useMemo } from 'react';
import Item from './ContextBlock.Item';
const ContextBlock = ({ className, block, surfaceRenderer }) => {
    const itemElements = useMemo(() => block.elements.map((element) => (Object.assign(Object.assign({}, element), { appId: block.appId, blockId: block.blockId }))), [block.appId, block.blockId, block.elements]);
    return (_jsx(Box, { className: className, display: 'flex', alignItems: 'center', margin: -4, children: itemElements.map((element, i) => (_jsx(Item, { block: element, surfaceRenderer: surfaceRenderer, index: i }, i))) }));
};
export default memo(ContextBlock);
//# sourceMappingURL=ContextBlock.js.map