import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, Skeleton } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { memo, useEffect, useState } from 'react';
import { Image } from './ImageBlock.styles';
import { useSurfaceType } from '../hooks/useSurfaceType';
const maxSize = 360;
const fetchImageState = (img) => {
    if (!img.complete) {
        return {
            loading: true,
            width: maxSize,
            height: (maxSize * 9) / 21,
        };
    }
    const { naturalWidth, naturalHeight } = img;
    const scaleRatio = naturalWidth > naturalHeight ? Math.min(naturalWidth, maxSize) / naturalWidth : Math.min(naturalHeight, maxSize) / naturalHeight;
    return {
        loading: false,
        width: naturalWidth * scaleRatio,
        height: naturalHeight * scaleRatio,
    };
};
const ImageBlock = ({ className, block, surfaceRenderer }) => {
    const surface = useSurfaceType();
    const alignment = surface === 'banner' || surface === 'message' ? 'flex-start' : 'center';
    const [{ loading, width, height }, setState] = useState(() => {
        const img = document.createElement('img');
        img.src = block.imageUrl;
        return fetchImageState(img);
    });
    useEffect(() => {
        const img = document.createElement('img');
        const handleLoad = () => {
            setState(fetchImageState(img));
        };
        img.addEventListener('load', handleLoad);
        img.src = block.imageUrl;
        if (img.complete) {
            img.removeEventListener('load', handleLoad);
            setState(fetchImageState(img));
        }
        return () => {
            img.removeEventListener('load', handleLoad);
        };
    }, [block.imageUrl]);
    return (_jsx(Box, { className: className, display: 'flex', flexDirection: 'column', flexWrap: 'nowrap', alignItems: alignment, children: _jsxs(Box, { overflow: 'hidden', width: width, children: [block.title && (_jsx(Box, { fontScale: 'c1', color: 'hint', withTruncatedText: true, marginBlockEnd: 4, children: surfaceRenderer.renderTextObject(block.title, 0, UiKit.BlockContext.NONE) })), loading ? (_jsx(Skeleton, { variant: 'rect', width: width, height: height })) : (_jsx(Image, { imageUrl: block.imageUrl, width: width, height: height, "aria-label": block.altText }))] }) }));
};
export default memo(ImageBlock);
//# sourceMappingURL=ImageBlock.js.map