import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Field, FieldLabel, FieldRow, FieldError, FieldHint } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { memo, useMemo } from 'react';
import { useUiKitState } from '../hooks/useUiKitState';
const InputBlock = ({ className, block, surfaceRenderer, context }) => {
    const inputElement = useMemo(() => {
        var _a, _b;
        return (Object.assign(Object.assign({}, block.element), { appId: (_a = block.element.appId) !== null && _a !== void 0 ? _a : block.appId, blockId: (_b = block.element.blockId) !== null && _b !== void 0 ? _b : block.blockId }));
    }, [block.element, block.appId, block.blockId]);
    const [{ error }] = useUiKitState(inputElement, context);
    return (_jsxs(Field, { className: className, children: [block.label && _jsx(FieldLabel, { children: surfaceRenderer.renderTextObject(block.label, 0, UiKit.BlockContext.NONE) }), _jsx(FieldRow, { children: surfaceRenderer.renderInputBlockElement(inputElement, 0) }), error && _jsx(FieldError, { children: error }), block.hint && _jsx(FieldHint, { children: surfaceRenderer.renderTextObject(block.hint, 0, UiKit.BlockContext.NONE) })] }));
};
export default memo(InputBlock);
//# sourceMappingURL=InputBlock.js.map