import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { MessageGenericPreview, MessageGenericPreviewContent, MessageGenericPreviewDescription, MessageGenericPreviewCoverImage, MessageGenericPreviewTitle, MessageGenericPreviewFooter, MessageGenericPreviewThumb, Box, } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { isPreviewBlockWithThumb, isPreviewBlockWithPreview } from '@rocket.chat/ui-kit';
import { memo } from 'react';
import ContextBlock from './ContextBlock';
const PreviewBlock = ({ block, surfaceRenderer }) => {
    var _a;
    return (_jsx(Box, { children: _jsxs(MessageGenericPreview, { children: [isPreviewBlockWithPreview(block) && ((_a = block.preview) === null || _a === void 0 ? void 0 : _a.dimensions) && (_jsx(MessageGenericPreviewCoverImage, { width: block.preview.dimensions.width, height: block.preview.dimensions.height, url: block.preview.url })), _jsxs(MessageGenericPreviewContent, { thumb: isPreviewBlockWithThumb(block) ? (_jsx(MessageGenericPreviewThumb, { children: _jsx(MessageGenericPreviewCoverImage, { height: 192, width: 368, url: block.thumb.url }) })) : undefined, children: [Array.isArray(block.title) ? (_jsx(MessageGenericPreviewTitle, { externalUrl: isPreviewBlockWithPreview(block) ? block.externalUrl : undefined, children: block.title.map((title) => surfaceRenderer.renderTextObject(title, 0, UiKit.BlockContext.NONE)) })) : null, Array.isArray(block.description) ? (_jsx(MessageGenericPreviewDescription, { clamp: true, children: block.description.map((description) => surfaceRenderer.renderTextObject(description, 0, UiKit.BlockContext.NONE)) })) : null, block.footer && (_jsx(MessageGenericPreviewFooter, { children: _jsx(ContextBlock, { block: block.footer, surfaceRenderer: surfaceRenderer, context: UiKit.BlockContext.BLOCK, index: 0 }) }))] })] }) }));
};
export default memo(PreviewBlock);
//# sourceMappingURL=PreviewBlock.js.map