import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { getUserDisplayName, VideoConferenceStatus } from '@rocket.chat/core-typings';
import { useGoToRoom, useSetting, useTranslation, useUserId, useUserPreference } from '@rocket.chat/ui-contexts';
import { VideoConfMessageSkeleton, VideoConfMessage, VideoConfMessageRow, VideoConfMessageIcon, VideoConfMessageText, VideoConfMessageFooter, VideoConfMessageUserStack, VideoConfMessageFooterText, VideoConfMessageButton, VideoConfMessageContent, VideoConfMessageActions, VideoConfMessageAction, } from '@rocket.chat/ui-video-conf';
import { useContext, memo, useMemo } from 'react';
import { UiKitContext } from '../..';
import { useVideoConfDataStream } from './hooks/useVideoConfDataStream';
import { useSurfaceType } from '../../hooks/useSurfaceType';
const MAX_USERS = 3;
const VideoConferenceBlock = ({ block }) => {
    var _a;
    const t = useTranslation();
    const { callId, appId = 'videoconf-core' } = block;
    const surfaceType = useSurfaceType();
    const userId = useUserId();
    const goToRoom = useGoToRoom();
    const displayAvatars = useUserPreference('displayAvatars');
    const showRealName = useSetting('UI_Use_Real_Name', false);
    const { action, viewId = undefined, rid } = useContext(UiKitContext);
    if (surfaceType !== 'message') {
        throw new Error('VideoConferenceBlock cannot be rendered outside message');
    }
    if (!rid) {
        throw new Error('VideoConferenceBlock cannot be rendered without rid');
    }
    const result = useVideoConfDataStream({ rid, callId });
    const joinHandler = (e) => {
        action({
            blockId: block.blockId || '',
            appId,
            actionId: 'join',
            value: block.blockId || '',
            viewId,
        }, e);
    };
    const callAgainHandler = (e) => {
        action({
            blockId: rid || '',
            appId,
            actionId: 'callBack',
            value: rid || '',
            viewId,
        }, e);
    };
    const openCallInfo = (e) => {
        action({
            blockId: callId,
            appId,
            actionId: 'info',
            value: rid,
            viewId,
        }, e);
    };
    const openDiscussion = (_e) => {
        if (data.discussionRid) {
            goToRoom(data.discussionRid);
        }
    };
    const messageFooterText = useMemo(() => {
        var _a;
        const usersCount = (_a = result.data) === null || _a === void 0 ? void 0 : _a.users.length;
        if (!displayAvatars) {
            return t('__usersCount__joined', {
                count: usersCount,
            });
        }
        return usersCount && usersCount > MAX_USERS
            ? t('plus__usersCount__joined', {
                count: usersCount - MAX_USERS,
            })
            : t('joined');
    }, [displayAvatars, t, (_a = result.data) === null || _a === void 0 ? void 0 : _a.users.length]);
    if (result.isPending || result.isError) {
        // TODO: error handling
        return _jsx(VideoConfMessageSkeleton, {});
    }
    const { data } = result;
    const isUserCaller = data.createdBy._id === userId;
    const joinedNamesOrUsernames = [...data.users]
        .splice(0, MAX_USERS)
        .map(({ name, username }) => getUserDisplayName(name, username, showRealName))
        .join(', ');
    const title = data.users.length > MAX_USERS
        ? t('__usernames__and__count__more_joined', {
            usernames: joinedNamesOrUsernames,
            count: data.users.length - MAX_USERS,
        })
        : t('__usernames__joined', { usernames: joinedNamesOrUsernames });
    const actions = (_jsxs(VideoConfMessageActions, { children: [data.discussionRid && _jsx(VideoConfMessageAction, { icon: 'discussion', title: t('Join_discussion'), onClick: openDiscussion }), _jsx(VideoConfMessageAction, { icon: 'info', onClick: openCallInfo })] }));
    if ('endedAt' in data) {
        return (_jsxs(VideoConfMessage, { children: [_jsxs(VideoConfMessageRow, { children: [_jsxs(VideoConfMessageContent, { children: [_jsx(VideoConfMessageIcon, {}), _jsx(VideoConfMessageText, { children: t('Call_ended') })] }), actions] }), _jsxs(VideoConfMessageFooter, { children: [data.type === 'direct' && (_jsxs(_Fragment, { children: [_jsx(VideoConfMessageButton, { onClick: callAgainHandler, children: isUserCaller ? t('Call_again') : t('Call_back') }), [VideoConferenceStatus.EXPIRED, VideoConferenceStatus.DECLINED].includes(data.status) && (_jsx(VideoConfMessageFooterText, { children: t('Call_was_not_answered') }))] })), data.type !== 'direct' &&
                            (data.users.length ? (_jsxs(_Fragment, { children: [_jsx(VideoConfMessageUserStack, { users: data.users }), _jsx(VideoConfMessageFooterText, { title: title, children: messageFooterText })] })) : ([VideoConferenceStatus.EXPIRED, VideoConferenceStatus.DECLINED].includes(data.status) && (_jsx(VideoConfMessageFooterText, { children: t('Call_was_not_answered') }))))] })] }));
    }
    if (data.type === 'direct' && data.status === VideoConferenceStatus.CALLING) {
        return (_jsxs(VideoConfMessage, { children: [_jsxs(VideoConfMessageRow, { children: [_jsxs(VideoConfMessageContent, { children: [_jsx(VideoConfMessageIcon, { variant: 'incoming' }), _jsx(VideoConfMessageText, { children: t('Calling') })] }), actions] }), _jsx(VideoConfMessageFooter, { children: _jsx(VideoConfMessageFooterText, { children: t('Waiting_for_answer') }) })] }));
    }
    return (_jsxs(VideoConfMessage, { children: [_jsxs(VideoConfMessageRow, { children: [_jsxs(VideoConfMessageContent, { children: [_jsx(VideoConfMessageIcon, { variant: 'outgoing' }), _jsx(VideoConfMessageText, { children: t('Call_ongoing') })] }), actions] }), _jsxs(VideoConfMessageFooter, { children: [_jsx(VideoConfMessageButton, { primary: true, onClick: joinHandler, children: t('Join') }), Boolean(data.users.length) && (_jsxs(_Fragment, { children: [_jsx(VideoConfMessageUserStack, { users: data.users }), _jsx(VideoConfMessageFooterText, { title: title, children: messageFooterText })] }))] })] }));
};
export default memo(VideoConferenceBlock);
//# sourceMappingURL=VideoConferenceBlock.js.map