import { useEndpoint } from '@rocket.chat/ui-contexts';
import { useQuery } from '@tanstack/react-query';
export const useVideoConfData = ({ callId }) => {
    const getVideoConfInfo = useEndpoint('GET', '/v1/video-conference.info');
    return useQuery({
        queryKey: ['video-conference', callId],
        queryFn: () => getVideoConfInfo({ callId }),
        staleTime: Infinity,
        refetchOnMount: (query) => {
            var _a;
            if ((_a = query.state.data) === null || _a === void 0 ? void 0 : _a.endedAt) {
                return false;
            }
            return 'always';
        },
    });
};
//# sourceMappingURL=useVideoConfData.js.map