import { Fragment as _Fragment, jsx as _jsx } from "react/jsx-runtime";
import { createContext, useContext, useDebugValue } from 'react';
import { UiKitContext } from './UiKitContext';
const AppIdContext = createContext(undefined);
export const AppIdProvider = ({ children, appId }) => {
    if (!appId) {
        return _jsx(_Fragment, { children: children });
    }
    return _jsx(AppIdContext.Provider, { value: appId, children: children });
};
export const useAppId = () => {
    var _a, _b;
    const outerAppId = (_a = useContext(UiKitContext).appId) !== null && _a !== void 0 ? _a : 'core';
    const appId = (_b = useContext(AppIdContext)) !== null && _b !== void 0 ? _b : outerAppId;
    useDebugValue(appId);
    return appId;
};
//# sourceMappingURL=AppIdContext.js.map