import { jsx as _jsx } from "react/jsx-runtime";
import { Button, Throbber } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { useUiKitState } from '../hooks/useUiKitState';
const ButtonElement = ({ block, context, surfaceRenderer }) => {
    const [{ loading }, action] = useUiKitState(block, context);
    const { style, url, text, value, secondary } = block;
    const handleClick = (e) => {
        action({ target: e.currentTarget });
    };
    if (url) {
        return (_jsx(Button, { is: 'a', target: '_blank', small: true, minWidth: '4ch', disabled: loading, href: url, primary: style === 'primary', danger: style === 'danger', success: style === 'success', warning: style === 'warning', secondary: secondary, onClick: handleClick, children: loading ? _jsx(Throbber, {}) : surfaceRenderer.renderTextObject(text, 0, UiKit.BlockContext.NONE) }));
    }
    return (_jsx(Button, { small: true, minWidth: '4ch', disabled: loading, primary: style === 'primary', danger: style === 'danger', success: style === 'success', warning: style === 'warning', secondary: secondary, value: value, onClick: handleClick, children: loading ? _jsx(Throbber, {}) : surfaceRenderer.renderTextObject(text, 0, UiKit.BlockContext.NONE) }));
};
export default ButtonElement;
//# sourceMappingURL=ButtonElement.js.map