var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { AutoComplete, Option, Box, Chip } from '@rocket.chat/fuselage';
import { useDebouncedValue } from '@rocket.chat/fuselage-hooks';
import { RoomAvatar } from '@rocket.chat/ui-avatar';
import { memo, useCallback, useState } from 'react';
import { useChannelsData } from './hooks/useChannelsData';
import { useUiKitState } from '../../hooks/useUiKitState';
const ChannelsSelectElement = ({ block, context }) => {
    const [{ value, loading }, action] = useUiKitState(block, context);
    const [filter, setFilter] = useState('');
    const filterDebounced = useDebouncedValue(filter, 300);
    const options = useChannelsData({ filter: filterDebounced });
    const handleChange = useCallback((value) => {
        if (!Array.isArray(value))
            action({ target: { value } });
    }, [action]);
    return (_jsx(AutoComplete, { value: value, onChange: handleChange, disabled: loading, filter: filter, setFilter: setFilter, renderSelected: ({ selected: { value, label } }) => (_jsxs(Chip, { height: 'x20', value: value, mie: 4, children: [_jsx(RoomAvatar, { size: 'x20', room: Object.assign(Object.assign({ _id: value }, label), { type: (label === null || label === void 0 ? void 0 : label.type) || 'c' }) }), _jsx(Box, { verticalAlign: 'middle', is: 'span', margin: 'none', mi: 4, children: label.name })] })), renderItem: (_a) => {
            var { value, label } = _a, props = __rest(_a, ["value", "label"]);
            return (_jsx(Option, Object.assign({}, props, { label: label.name, avatar: _jsx(RoomAvatar, Object.assign({ size: 'x20', room: {
                        type: label.type,
                        _id: value,
                        avatarETag: label.avatarETag,
                    } }, props)) }), value));
        }, options: options }));
};
export default memo(ChannelsSelectElement);
//# sourceMappingURL=ChannelsSelectElement.js.map