var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { AutoComplete, Option, Chip, Box } from '@rocket.chat/fuselage';
import { useDebouncedValue } from '@rocket.chat/fuselage-hooks';
import { RoomAvatar } from '@rocket.chat/ui-avatar';
import { memo, useCallback, useState } from 'react';
import { useChannelsData } from './hooks/useChannelsData';
import { useUiKitState } from '../../hooks/useUiKitState';
const MultiChannelsSelectElement = ({ block, context }) => {
    const [{ value, loading }, action] = useUiKitState(block, context);
    const [filter, setFilter] = useState('');
    const filterDebounced = useDebouncedValue(filter, 300);
    const options = useChannelsData({ filter: filterDebounced });
    const handleChange = useCallback((value) => {
        if (Array.isArray(value))
            action({ target: { value } });
    }, [action]);
    return (_jsx(AutoComplete, { value: value || [], disabled: loading, onChange: handleChange, filter: filter, setFilter: setFilter, multiple: true, renderSelected: (_a) => {
            var { selected: { value, label }, onRemove } = _a, props = __rest(_a, ["selected", "onRemove"]);
            return (_jsxs(Chip, Object.assign({}, props, { value: value, onClick: onRemove, children: [_jsx(RoomAvatar, { size: 'x20', room: Object.assign(Object.assign({ _id: value }, label), { type: (label === null || label === void 0 ? void 0 : label.type) || 'c' }) }), _jsx(Box, { is: 'span', margin: 'none', mis: 4, children: label === null || label === void 0 ? void 0 : label.name })] }), value));
        }, renderItem: (_a) => {
            var { value, label } = _a, props = __rest(_a, ["value", "label"]);
            return (_jsx(Option, Object.assign({}, props, { label: label.name, avatar: _jsx(RoomAvatar, { size: 'x20', room: Object.assign(Object.assign({ _id: value }, label), { type: (label === null || label === void 0 ? void 0 : label.type) || 'c' }) }) }), value));
        }, options: options }));
};
export default memo(MultiChannelsSelectElement);
//# sourceMappingURL=MultiChannelsSelectElement.js.map