import { jsx as _jsx } from "react/jsx-runtime";
import { IconButton } from '@rocket.chat/fuselage';
import { useUiKitState } from '../hooks/useUiKitState';
const IconButtonElement = ({ block, context }) => {
    const [{ loading }, action] = useUiKitState(block, context);
    const { url, value, label, icon } = block;
    const { icon: iconName, variant } = icon;
    const handleClick = (e) => {
        action({ target: e.currentTarget });
    };
    if (url) {
        return _jsx(IconButton, { small: true, is: 'a', target: '_blank', disabled: loading, icon: iconName, href: url, onClick: handleClick, label: label });
    }
    return (_jsx(IconButton, { icon: iconName, color: variant === 'default' ? 'default' : 'danger', small: true, label: label, disabled: loading, value: value, onClick: handleClick }));
};
export default IconButtonElement;
//# sourceMappingURL=IconButtonElement.js.map