import { jsx as _jsx } from "react/jsx-runtime";
import { TextAreaInput, TextInput } from '@rocket.chat/fuselage';
import { memo } from 'react';
import { useStringFromTextObject } from '../hooks/useStringFromTextObject';
import { useUiKitState } from '../hooks/useUiKitState';
const PlainTextInputElement = ({ block, context }) => {
    const [{ loading, value, error }, action] = useUiKitState(block, context);
    const fromTextObjectToString = useStringFromTextObject();
    if (block.multiline) {
        return (_jsx(TextAreaInput, { disabled: loading, id: block.actionId, name: block.actionId, rows: 6, error: error, value: value, onChange: action, placeholder: fromTextObjectToString(block.placeholder) }));
    }
    return (_jsx(TextInput, { disabled: loading, id: block.actionId, name: block.actionId, error: error, value: value, onChange: action, placeholder: fromTextObjectToString(block.placeholder) }));
};
export default memo(PlainTextInputElement);
//# sourceMappingURL=PlainTextInputElement.js.map