import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Box, RadioButton } from '@rocket.chat/fuselage';
import * as UiKit from '@rocket.chat/ui-kit';
import { useUiKitState } from '../hooks/useUiKitState';
const RadioButtonElement = ({ block, context, surfaceRenderer }) => {
    const [{ loading, value }, action] = useUiKitState(block, context);
    const { options } = block;
    return (_jsx(Box, { children: options.map((option) => (_jsxs(Box, { pb: 4, children: [_jsx(RadioButton, { disabled: loading, checked: value === option.value, value: option.value, onChange: action }), _jsx(Box, { is: 'label', pis: 8, children: surfaceRenderer.renderTextObject(option.text, 0, UiKit.BlockContext.NONE) })] }, option.value))) }));
};
export default RadioButtonElement;
//# sourceMappingURL=RadioButtonElement.js.map