import { jsx as _jsx } from "react/jsx-runtime";
import { SelectFiltered } from '@rocket.chat/fuselage';
import { memo, useCallback, useMemo } from 'react';
import { useStringFromTextObject } from '../hooks/useStringFromTextObject';
import { useUiKitState } from '../hooks/useUiKitState';
const StaticSelectElement = ({ block, context }) => {
    const [{ loading, value, error }, action] = useUiKitState(block, context);
    const fromTextObjectToString = useStringFromTextObject();
    const options = useMemo(() => block.options.map((option) => { var _a; return [option.value, (_a = fromTextObjectToString(option.text)) !== null && _a !== void 0 ? _a : '']; }), [block.options, fromTextObjectToString]);
    const handleChange = useCallback((value) => {
        action({ target: { value } });
    }, [action]);
    return (_jsx(SelectFiltered, { value: value, disabled: loading, error: error, options: options, placeholder: fromTextObjectToString(block.placeholder), onChange: handleChange }));
};
export default memo(StaticSelectElement);
//# sourceMappingURL=StaticSelectElement.js.map