import { jsx as _jsx } from "react/jsx-runtime";
import { InputBox } from '@rocket.chat/fuselage';
import { useStringFromTextObject } from '../hooks/useStringFromTextObject';
import { useUiKitState } from '../hooks/useUiKitState';
const TimePickerElement = ({ block, context }) => {
    const [{ loading, value, error }, action] = useUiKitState(block, context);
    const { actionId, placeholder } = block;
    const fromTextObjectToString = useStringFromTextObject();
    return (_jsx(InputBox, { type: 'time', error: error, value: value, disabled: loading, id: actionId, name: actionId, rows: 6, placeholder: fromTextObjectToString(placeholder), onInput: action }));
};
export default TimePickerElement;
//# sourceMappingURL=TimePickerElement.js.map